<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('country_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('country_id', 36)->index('country_i18ns_country_id_foreign');
            $table->string('country_name');
            $table->string('language_code')->index('country_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('country_i18ns');
    }
};
