<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('core_suppliers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('core_service_type_id')->default(0);
            $table->string('name');
            $table->string('code')->nullable();
            $table->string('description')->nullable();
            $table->string('cover_image')->nullable();
            $table->tinyInteger('is_active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('core_suppliers');
    }
};
