<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('core_languages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('language_code')->unique()->comment('language code');
            $table->string('language_name')->comment('language name');
            $table->set('language_type', ['LTR', 'RTL'])->default('LTR')->comment('language type i.e LTR(Left To Right), RTL(Right To Left)');
            $table->tinyInteger('status')->default(1);
            $table->integer('sort_order')->nullable()->default(0);
            $table->tinyInteger('is_default')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('core_languages');
    }
};
