<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('city_images', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('country_code');
            $table->string('country_name');
            $table->string('country_name_arabic');
            $table->string('city_code');
            $table->string('city_name');
            $table->string('city_name_arabic');
            $table->string('thumbnail');
            $table->tinyInteger('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('city_images');
    }
};
