<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('city_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('city_id', 36)->index('city_i18ns_city_id_foreign');
            $table->string('city_name');
            $table->string('language_code')->index('city_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('city_i18ns');
    }
};
