<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cashbacks', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('booking_id')->nullable();
            $table->string('customer_id')->nullable();
            $table->string('coupon_id')->nullable();
            $table->string('cashback_amount', 50)->nullable();
            $table->date('expiry_date')->nullable()->comment('Service end date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cashbacks');
    }
};
