<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('booking_ref');
            $table->string('rehtle_ref')->nullable();
            $table->string('ref_id')->nullable();
            $table->string('booking_type')->nullable();
            $table->string('supplier_booking_ref')->nullable();
            $table->string('supplier_booking_associated_ref')->nullable();
            $table->string('booking_segment_id')->nullable();
            $table->string('ticket_numbers')->nullable();
            $table->unsignedBigInteger('supplier_id')->comment('reference id key of core suppliers table');
            $table->string('supplier_name', 100)->nullable();
            $table->date('booking_date');
            $table->date('booking_start_date');
            $table->unsignedBigInteger('service_id')->comment('reference id key of core service types table');
            $table->char('customer_id', 36)->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone_country_code')->nullable();
            $table->string('phone')->nullable();
            $table->unsignedBigInteger('agency_id')->comment('agency id = 0 is for B2C agency will be default');
            $table->string('description')->comment('I.e for flight “Delhi to Longon (Round Trip)”, for hotel “Hotel Amar Inn”');
            $table->decimal('booking_points', 10)->nullable();
            $table->integer('redeem_points')->nullable();
            $table->decimal('sub_total', 10)->default(0)->comment('booking all total price including tax and everything');
            $table->decimal('tax', 10)->default(0)->comment('tax percentage value I.e 15.00, 19.50');
            $table->decimal('s_markup_fee', 10)->nullable();
            $table->decimal('s_service_fee', 10)->nullable();
            $table->decimal('s_markup_service_fee', 10)->nullable();
            $table->decimal('s_tax', 10)->default(0)->comment('tax received by suppliers');
            $table->decimal('s_charge', 10)->default(0)->comment('charges added by admin');
            $table->decimal('s_discount_type', 10)->default(0)->comment('fixed or percent');
            $table->decimal('s_discount_value', 10)->default(0)->comment('discount value');
            $table->decimal('s_discount', 10)->default(0)->comment('discount amount');
            $table->decimal('t_discount_type', 10)->default(0)->comment('fixed or percent');
            $table->decimal('t_discount_value', 10)->default(0)->comment('discount value');
            $table->decimal('t_discount', 10)->default(0)->comment('discount amount');
            $table->string('t_markup_type')->default('0.00')->comment('fixed or percent');
            $table->decimal('t_markup_value', 10)->default(0)->comment('markup value');
            $table->decimal('t_markup', 10)->default(0)->comment('markup amount');
            $table->decimal('travelers_price', 10)->nullable();
            $table->decimal('chargeable_seat_price', 10)->nullable();
            $table->decimal('total', 10)->nullable();
            $table->decimal('booking_cancel_amount', 10)->nullable();
            $table->decimal('processed_cancel_amount', 10)->nullable();
            $table->longText('booking_details')->nullable()->comment('store whole json value that receives from suppliers');
            $table->enum('booking_status', ['pending', 'processing', 'confirmed', 'failed', 'cancelled', 'cancelled not refunded', 'cancelled and refunded'])->nullable();
            $table->text('booking_status_description')->nullable();
            $table->string('booking_sub_status')->nullable();
            $table->text('booking_status_message')->nullable();
            $table->string('supplier_currency')->nullable()->comment('store supplier currency code');
            $table->string('customer_currency')->nullable()->comment('store customer currency code');
            $table->decimal('currency_conversion_rate', 10)->default(0)->comment('store currency conversion rate at time of booking');
            $table->decimal('currency_markup', 10)->default(0)->comment('store currency markup at time of booking');
            $table->string('customer_language_code');
            $table->enum('is_guest', ['true', 'false'])->default('false');
            $table->string('billing_address1');
            $table->string('billing_address2')->nullable();
            $table->string('billing_city');
            $table->string('billing_state');
            $table->string('billing_country');
            $table->string('billing_zip');
            $table->longText('service_provider_request')->nullable();
            $table->longText('service_provider_response')->nullable();
            $table->longText('service_provider_issuance_response')->nullable();
            $table->longText('service_provider_cancel_response')->nullable();
            $table->string('booking_from')->nullable()->default('web');
            $table->integer('addon_added')->default(0);
            $table->decimal('addon_amount', 10)->default(0);
            $table->integer('coupon_used')->default(0);
            $table->string('coupon_code')->nullable();
            $table->decimal('coupon_amount', 10)->default(0);
            $table->integer('wallet_used')->default(0);
            $table->decimal('wallet_amount', 10)->default(0);
            $table->integer('redeem_used')->default(0);
            $table->decimal('redeem_amount', 10)->default(0);
            $table->string('service_provider')->nullable();
            $table->text('additional_details')->nullable();
            $table->timestamp('booking_cancel_at')->nullable();
            $table->integer('email_notification')->default(0);
            $table->integer('sms_notification')->default(0);
            $table->integer('whatsapp_notification')->default(0);
            $table->integer('ticket_issued')->default(0);
            $table->integer('traacs_created')->default(0);
            $table->tinyInteger('booking_processed')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bookings');
    }
};
