<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('booking_logs', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('ref_id');
            $table->string('booking_type', 50);
            $table->string('customer_id')->nullable();
            $table->string('email');
            $table->string('phone_code');
            $table->string('phone_no');
            $table->longText('payload');
            $table->longText('booking_details')->nullable();
            $table->double('amount')->default(0);
            $table->string('currency', 10)->nullable();
            $table->string('status')->default('reached_payment');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('booking_logs');
    }
};
