<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('airlines_back', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('airline_code')->index('airlines_airline_code_index');
            $table->string('airline_logo')->nullable()->comment('Airline Logo');
            $table->tinyInteger('is_domestic');
            $table->enum('status', ['active', 'inactive']);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('airlines_back');
    }
};
