<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_settings', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('title_en');
            $table->string('title_ar');
            $table->string('address_en');
            $table->string('address_ar');
            $table->string('city_en');
            $table->string('city_ar');
            $table->string('country_en');
            $table->string('country_ar');
            $table->integer('pincode');
            $table->string('email');
            $table->string('phone_code');
            $table->string('phone_no');
            $table->string('logo_en');
            $table->string('logo_ar');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_settings');
    }
};
