<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_service_markups', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('service_name'); 
            $table->string('service_type'); 
            $table->string('cabin_class')->nullable(); 
            $table->integer('markup_percentage')->default(0);
            $table->integer('fixed_service_fee')->default(0);
            $table->string('sales_service_type');
            $table->string('status')->default('active'); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_service_markups');
    }
};
