<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWalletsTable extends Migration
{
    public function up()
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->unsignedBigInteger('customer_id'); // Foreign key
            $table->integer('balance')->default(0); // Wallet balance
            $table->string('attachment')->nullable()->default(null);
            $table->enum('status', ['active', 'inactive'])->default('active'); // Status
            $table->timestamps(); // Created at & updated at
        });
    }

    public function down()
    {
        Schema::dropIfExists('wallets');
    }
}
