<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use App\Enums\Locale;
use App\Services\CurlRequestService;
use Illuminate\Support\Facades\Storage;

trait WhatsappService
{

	private function getFlightWhatsappPayload($params, $locale = Locale::English->value)
	{
		if ($locale == Locale::English->value) {
			return array(
				"to" => $params[6],
				"templateName" => "flight_booking_confirmation",
				"language" => "en",
				"header" => null,
				"body" => array(
					"parameters" => [

						[
							"type" => "text",
							"text" => $params[0] // Flight No
						],
						[
							"type" => "text",
							"text" => $params[1] //Journey Date
						],
						[
							"type" => "text",
							"text" => $params[2] //Booking Ref
						],
						[
							"type" => "text",
							"text" => $params[3]  //PNR
						],
					]
				),

				"button" => null

			);
		} else {
			return array(
				"to" => $params[6],
				"templateName" => "flight_booking_confirmation_ar",
				"language" => "ar",
				"header" => null,
				"body" => array(
					"parameters" => [

						[
							"type" => "text",
							"text" => $params[0] // Flight No
						],
						[
							"type" => "text",
							"text" => $params[4] // Route
						],
						[
							"type" => "text",
							"text" => $params[1] //Journey Date
						],
						[
							"type" => "text",
							"text" => $params[2] //Booking Ref
						],
						[
							"type" => "text",
							"text" => $params[3] //PNR
						],
					]
				),

				"button" => null

			);
		}
	}
	private function getHotelWhatsappPayload($params, $locale = Locale::English->value)
	{
		if ($locale == Locale::English->value) {
			return array(
				"to" => $params[6],
				"templateName" => "hotel_booking_confirmation",
				"language" => "en",
				"header" => null,
				"body" => array(
					"parameters" => [
						[
							"type" => "text",
							"text" => $params[0]
						],
						[
							"type" => "text",
							"text" => $params[1]
						],
						[
							"type" => "text",
							"text" => $params[2]
						],
						[
							"type" => "text",
							"text" => $params[3]
						],
						[
							"type" => "text",
							"text" => $params[4]
						],

					]
				),

				"button" => null

			);
		} else {
		}
	}
	public function sendWhatsappmessage($params, $customerLanguageCode)
	{
		if ($params[5] == "flight_booking_conf_temp") {
			$data = self::getFlightWhatsappPayload($params, $customerLanguageCode);
		} else {

			$data = self::getHotelWhatsappPayload($params, $customerLanguageCode);
		}
		$url = 'https://api.telinfy.net/gagp/whatsapp/templates/message';
		//echo "<pre>";
		//print_r($data);die;
		// $data_string = json_encode($data);
		// $ch = curl_init();
		// curl_setopt($ch, CURLOPT_URL, $url);
		// curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		// curl_setopt($ch, CURLOPT_POST, 1);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

		// $headers = array();
		// $headers[] = 'Api-Key: 7175481f-fc8a-4cae-98a2-f28e59066a39';
		// $headers[] = 'Content-Type: application/json';
		// curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		// $result = curl_exec($ch);
		$result = CurlRequestService::sendRequest([
			'method' => 'POST',
			'url'    => $url,
			'headers' => [
				'Content-Type: application/json',
				'Api-Key: ' . env('WHATSAPP_API_KEY'),
			],
			'body'   => json_encode($data),
		]);
		return $result;
		if ($result) {
			return true;
		}
		\Log::error('WhatsApp API error', ['response' => $result]);
		return false;
	}

	public function sendWhatsappmessageOtp($mobile_number, $otp)
	{
		$data = array(
			"to" => $mobile_number,
			"templateName" => "june24",
			"language" => "en",
			"header" => null,
			"body" => array(
				"parameters" => [
					[
						"type" => "text",
						"text" => $otp
					]
				]
			),
			"button" => [
				[
					"type" => "copy_code",
					"parameters" => [
						[
							"type" => "text",
							"text" => $otp
						]
					]
				]
			]
		);

		$url = 'https://api.telinfy.net/gagp/whatsapp/templates/message';
		// $data_string = json_encode($data);
		// $ch = curl_init();
		// curl_setopt($ch, CURLOPT_URL, $url);
		// curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		// curl_setopt($ch, CURLOPT_POST, 1);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

		// $headers = array();
		// $headers[] = 'Api-Key: 7175481f-fc8a-4cae-98a2-f28e59066a39';
		// $headers[] = 'Content-Type: application/json';
		// curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = CurlRequestService::sendRequest([
			'method' => 'POST',
			'url'    => $url,
			'headers' => [
				'Content-Type: application/json',
				'Api-Key: ' . env('WHATSAPP_API_KEY'),
			],
			'body'   => json_encode($data),
		]);
		
		if ($result) {
			return true;
		}
		\Log::error('WhatsApp API error', ['response' => $result]);
		return false;
	}
}
