<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use App\Models\Bookings;
use App\Models\BookingAdditionalDetail;
use App\Models\TraacsLog;

trait TraacsService {
    public function getCreateVoucherPayloadWithEndPointUrl($bookingId) {
        $bookingDetails = Bookings::where('id', $bookingId)->first()->toArray();
        
        $bookingAdditionalDetails = BookingAdditionalDetail::where('booking_id', $bookingId)->first()->toArray();
        
        $bookingPayloadDetails = json_decode($bookingAdditionalDetails['booking_details'], true);
       
        $numberOfRooms = $totalAdults = $totalChildren = 0;
        foreach($bookingPayloadDetails['searchDetails']['occupancies'] as $occupancy) {
            $numberOfRooms += $occupancy['rooms'];
            $totalAdults += $occupancy['adults'];
            $totalChildren += $occupancy['children'];
        }

        $checkInDate = $bookingPayloadDetails['searchDetails']['stay']['checkIn'];
        $checkOutDate = $bookingPayloadDetails['searchDetails']['stay']['checkOut'];
        $checkInDateTs = strtotime($checkInDate);
        $checkOutDateTs = strtotime($checkOutDate);
        $checkDiff = $checkOutDateTs - $checkInDateTs;
        $numberOfNights = round($checkDiff / 86400);

        $bookedRooms = $Room_Details = [];
        if ($bookingDetails['service_provider'] == 'HOTEL_BEDS') {
            $roomsCount = count($bookingPayloadDetails['hotelDetails']['selectedRooms']['rooms']);
        } elseif ($bookingDetails['service_provider'] == 'GIMMONIX') {
            $roomsCount = count($bookingPayloadDetails['searchDetails']['occupancies']);
        }
        $providerNetPrice = $bookingPayloadDetails['processedPrice']['totalPrice'];
        $purchaseCurInputVat = ($providerNetPrice * 0.15);
        $purchaseCurTotalFare = $providerNetPrice;
        $purchaseCurSupplierAmount = $providerNetPrice + $purchaseCurInputVat;
        $purchaseCurTotalTax = $purchaseCurInputVat;
        $purchaseCurOutputVat = $bookingPayloadDetails['processedPrice']['vat'];
        $sellingCurServiceFee = $bookingPayloadDetails['processedPrice']['markupServiceFee'];
        $sellingCurPrice = $purchaseCurTotalFare + $sellingCurServiceFee;

        $roomPurchaseCurRatePerNight = $purchaseCurTotalFare / $roomsCount;
        $roomPurchaseCurTaxPerNight = $purchaseCurTotalTax / $roomsCount;
        $roomPurchaseCurSupplierAmount = $purchaseCurSupplierAmount / $roomsCount;
        $roomSellingCurServiceFee = $sellingCurServiceFee / $roomsCount;
        $roomSellingCurPrice = $sellingCurPrice / $roomsCount;
        if ($bookingDetails['service_provider'] == 'HOTEL_BEDS') {
            $city = '';
            if (isset($bookingPayloadDetails['hotelDetails']['hotelDetails']['city']) &&
                array_key_exists('content', $bookingPayloadDetails['hotelDetails']['hotelDetails']['city'])) {
                $city = $bookingPayloadDetails['hotelDetails']['hotelDetails']['city']['content'];
            } elseif (isset($bookingPayloadDetails['hotelDetails']['hotelDetails']['zone']) &&
                array_key_exists('content', $bookingPayloadDetails['hotelDetails']['hotelDetails']['zone'])) {
                $city = $bookingPayloadDetails['hotelDetails']['hotelDetails']['zone']['description']['content'];
            }
            $supplierConfNumber = str_replace('REH', 'HT', $bookingDetails['rehtle_ref']);
            $country = $bookingPayloadDetails['hotelDetails']['hotelDetails']['country']['description']['content'];
            $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['name']['content'];
            $guestName = ($bookingPayloadDetails['hotelDetails']['selectedRooms']['holder']['name'].' '.$bookingPayloadDetails['hotelDetails']['selectedRooms']['holder']['surname']);

            $roomNameBoardDetails = [];
            foreach($bookingPayloadDetails['hotelDetails']['hotelDetails']['rooms'] as $key => $room) {
                foreach($room['rates'] as $rate) {
                    $roomNameBoardDetails[$rate['rateKey']] = [
                        'roomName' => ucwords($room['name']),
                        'boardCode' => $rate['boardCode'],
                        'boardName' => $rate['boardName'],
                        'displayNet' => $rate['displayNet'],
                        'adults' => $rate['adults'],
                        'children' => $rate['children'],
                    ];
                }
            }

            foreach($bookingPayloadDetails['hotelDetails']['selectedRooms']['rooms'] as $key => $selectedRoom) {
                $bookedRooms[$key] = [
                    'room' => ('Room '.($key + 1)),
                    'roomName' => $roomNameBoardDetails[$selectedRoom['rateKey']]['roomName'],
                    'boardName' => $roomNameBoardDetails[$selectedRoom['rateKey']]['boardName'],
                    'paxes' => $selectedRoom['paxes'],
                    'rateComments' => '',
                ];

                array_push($Room_Details, [
                    "STR_CHECK_IN_DATE" => date('d-m-Y', strtotime($checkInDate)),
                    "STR_CHECK_OUT_DATE" => date('d-m-Y', strtotime($checkOutDate)),
                    "INT_NO_OF_ROOMS" => 1,
                    "INT_NO_OF_NIGHTS" => $numberOfNights,
                    "STR_MEALS_PLAN" => "FB",
                    "STR_TRAVELER_ID" => "",
                    "STR_GUESTS" => $guestName,
                    "STR_ADDITIONAL_GUESTS" => "",
                    "STR_ROOM_TYPE" => $roomNameBoardDetails[$selectedRoom['rateKey']]['roomName'],
                    "INT_ADULT" => $roomNameBoardDetails[$selectedRoom['rateKey']]['adults'],
                    "INT_CHILD" => $roomNameBoardDetails[$selectedRoom['rateKey']]['children'],
                    "DBL_PURCHASE_CUR_SUP_COMMISION" => 0,
                    "DBL_SELLING_CUR_EXTRA_EARNING" => 0,
                    "DBL_SELLING_CUR_PAYBACK_AMOUNT" => 0,
                    "DBL_SELLING_CUR_CC_CHARGES" => 0,
                    "DBL_SELLING_CUR_DISCOUNT" => 0,
                    "DBL_PURCHASE_CUR_RATE_PER_NIGHT" => $roomPurchaseCurRatePerNight,
                    "DBL_PURCHASE_CUR_TAX_PER_NIGHT" => $roomPurchaseCurTaxPerNight,
                    "DBL_PURCHASE_CUR_SUPPLIER_AMOUNT" => $roomPurchaseCurSupplierAmount,
                    "DBL_SELLING_CUR_SERVICE_FEE" => $roomSellingCurServiceFee,
                    "DBL_SELLING_CUR_PRICE" => $roomSellingCurPrice
                ]);
            }
            $roomBoardType = $bookedRooms[0]['roomName'];
        } elseif ($bookingDetails['service_provider'] == 'GIMMONIX') {
            // $city = $bookingPayloadDetails['additionalDetails']['city'] ?? '';
            if(isset($bookingPayloadDetails['searchDetails']['address']['city']) && $bookingPayloadDetails['searchDetails']['address']['city'] != '') {
                $city = $bookingPayloadDetails['searchDetails']['address']['city'];
            } elseif(isset($bookingPayloadDetails['searchDetails']['city']) && $bookingPayloadDetails['searchDetails']['city'] != '') {
                $city = $bookingPayloadDetails['searchDetails']['city'];
            } else {
                $city = '';
            }
            // $city = $bookingPayloadDetails['searchDetails']['address']['city'] ?? ($bookingPayloadDetails['searchDetails']['city'] ?? '');
    
            // $country = $bookingPayloadDetails['additionalDetails']['country'] ?? '';
            // $country = $bookingPayloadDetails['searchDetails']['address']['country'] ?? ($bookingPayloadDetails['searchDetails']['nationality'] ?? '');

            if (isset($bookingPayloadDetails['searchDetails']['address']['country']) && $bookingPayloadDetails['searchDetails']['address']['country'] != '') {
                $country = $bookingPayloadDetails['searchDetails']['address']['country'];
            } elseif (isset($bookingPayloadDetails['searchDetails']['nationality']) && $bookingPayloadDetails['searchDetails']['nationality'] != '') {
                $country = $bookingPayloadDetails['searchDetails']['nationality'];
            } else { 
                $country = '';
            }
            
            $supplierConfNumber = str_replace('REH', 'HT', $bookingDetails['rehtle_ref']);
           
            $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['DisplayName'];
            $guestName = ($bookingPayloadDetails['userDetails']['firstName'].' '.$bookingPayloadDetails['userDetails']['lastName']);
            
            $selectedRoom = $bookingPayloadDetails['hotelDetails']['selectedRooms'];
            $roomName = $selectedRoom['RoomName'] ?? '';
            $roomType = $selectedRoom['RoomType'] ?? '';
            $boardName = $selectedRoom['RoomBasis'] ?? '';
            
            $finalPrice = $selectedRoom['Price']['FinalPrice'];
            foreach($bookingPayloadDetails['searchDetails']['occupancies'] as $key => $occupancy) {
                
                array_push($Room_Details, [
                    "STR_CHECK_IN_DATE" => date('d-m-Y', strtotime($checkInDate)),
                    "STR_CHECK_OUT_DATE" => date('d-m-Y', strtotime($checkOutDate)),
                    "INT_NO_OF_ROOMS" => 1,
                    "INT_NO_OF_NIGHTS" => $numberOfNights,
                    "STR_MEALS_PLAN" => $boardName,
                    "STR_TRAVELER_ID" => "",
                    "STR_GUESTS" => $guestName,
                    "STR_ADDITIONAL_GUESTS" => "",
                    "STR_ROOM_NAME" => $roomName,
                    "STR_ROOM_TYPE" => $roomType,
                    "INT_ADULT" => $occupancy['adults'],
                    "INT_CHILD" => $occupancy['children'],
                    "DBL_PURCHASE_CUR_SUP_COMMISION" => 0,
                    "DBL_SELLING_CUR_EXTRA_EARNING" => 0,
                    "DBL_SELLING_CUR_PAYBACK_AMOUNT" => 0,
                    "DBL_SELLING_CUR_CC_CHARGES" => 0,
                    "DBL_SELLING_CUR_DISCOUNT" => 0,
                    "DBL_PURCHASE_CUR_RATE_PER_NIGHT" => $roomPurchaseCurRatePerNight,
                    "DBL_PURCHASE_CUR_TAX_PER_NIGHT" => $roomPurchaseCurTaxPerNight,
                    "DBL_PURCHASE_CUR_SUPPLIER_AMOUNT" => $roomPurchaseCurSupplierAmount,
                    "DBL_SELLING_CUR_SERVICE_FEE" => $roomSellingCurServiceFee,
                    "DBL_SELLING_CUR_PRICE" => $roomSellingCurPrice
                ]);
                
            }
            
            $roomBoardType = $roomName;
        }
        
        if (env('APP_ENV') == 'production') {
            $traacsEndPointUrl = env('TRAACS_PRODUCTION_VOUCHER_ENDPOINT');
            $userName = env('TRAACS_PRODUCTION_USER_NAME');
            $password = env('TRAACS_PRODUCTION_PASSWORD');
            $costCenterCode = env('TRAACS_PRODUCTION_COST_CENTRE_CODE');
            $departmentCode = env('TRAACS_PRODUCTION_DEPARTMENT_CODE');
            $accountCode = env('TRAACS_PRODUCTION_ACCOUNT_CODE');
            $supplierCode = env('TRAACS_PRODUCTION_STR_SUPPLIER_CODE');
            $staff = env('TRAACS_PRODUCTION_STAFF');
            $staffEmailId = env('TRAACS_PRODUCTION_STAFF_EMAIL_ID');
        } else {
            $traacsEndPointUrl = env('TRAACS_DEMO_VOUCHER_ENDPOINT');
            $userName = env('TRAACS_DEMO_USER_NAME');
            $password = env('TRAACS_DEMO_PASSWORD');
            $costCenterCode = env('TRAACS_DEMO_COST_CENTRE_CODE');
            $departmentCode = env('TRAACS_DEMO_DEPARTMENT_CODE');
            $accountCode = env('TRAACS_DEMO_ACCOUNT_CODE');
            $supplierCode = env('TRAACS_DEMO_STR_SUPPLIER_CODE');
            $staff = env('TRAACS_DEMO_STAFF');
            $staffEmailId = env('TRAACS_DEMO_STAFF_EMAIL_ID');
        }

        $traacsPayload = [
            "str_authentication_key" => [
                "STR_AUTHENTICATION" => "",
                "STR_USER_NAME" => $userName,
                "STR_PASSWORD" => $password
            ],
            "json_master" => [
                "STR_DOCUMENT_NO" => "",
                "STR_ACTION" => "NEW",
                "STR_INVOICE_DATE" => date('d/m/Y', strtotime($bookingDetails['booking_date'])),
                "STR_COST_CENTRE_CODE" => $costCenterCode,
                "STR_DEPARTMENT_CODE" => $departmentCode,
                "DBL_SELLING_ROE" => 1,
                "STR_SELLING_CUR_CODE" => $bookingDetails['customer_currency'],
                "STR_ACCOUNT_CODE" => $accountCode
            ],
            "json_Hotel" => [
                [
                    "STR_TYPE" => "VS",
                    "STR_VOUCHER_NO" => $bookingDetails['booking_ref'],
                    "STR_ISSUE_DATE" => date('d/m/Y', strtotime($bookingDetails['booking_date'])),
                    "STR_SUPPLIER_CODE" => $supplierCode,
                    "STR_SUPPLIER_CONF_NUMBER" => $supplierConfNumber,
                    "STR_COUNTRY" => $country,
                    "STR_CITY" => $city,
                    "STR_HOTEL_NAME" => $hotelName,
                    "STR_ROOM_TYPE" => $roomBoardType,
                    "STR_MEALS_PLAN" => $boardName,
                    "STR_CHECK_IN_DATE" => date('d-m-Y', strtotime($checkInDate)),
                    "STR_CHECK_OUT_DATE" => date('d-m-Y', strtotime($checkOutDate)),
                    "STR_HOTEL_CONF_NUMBER" => "",
                    "STR_PNR_NO" => "",
                    "STR_LPO_NO" => "Reconfirmed ".$hotelName,
                    "STR_TRAVELER_ID" => "",
                    "STR_GUESTS" => $guestName,
                    "STR_ADDITIONAL_GUESTS" => "",
                    "INT_NO_OF_ROOMS" => $numberOfRooms,
                    "INT_NO_OF_NIGHTS" => $numberOfNights,
                    "STR_PURCHASE_CUR_CODE" => $bookingDetails['customer_currency'],
                    "STR_STAFF" => $staff,
                    "STR_STAFF_EMAIL_ID" => $staffEmailId,
                    "STR_ORIGIN_COUNTRY" => "",
                    "STR_REMARKS" => "",
                    "STR_BOOKING_DETAILS" => "",
                    "STR_TAX_DETAILS" => "",
                    "DBL_SELLING_CUR_EXTRA_EARNING" => 0,
                    "DBL_SELLING_CUR_PAYBACK_AMOUNT" => 0,
                    "STR_PAYBACK_ACCOUNT_CODE" => "",
                    "DBL_SELLING_CUR_CC_CHARGES" => 0,
                    "DBL_SELLING_CUR_DISCOUNT" => 0,
                    "DBL_PURCHASE_CUR_SUP_COMMISION" => 0,
                    "DBL_PURCHASE_CUR_SUPPLIER_FEE" => 0,
                    "DBL_PURCHASE_CUR_TOTAL_FARE" => $purchaseCurTotalFare,
                    "DBL_PURCHASE_CUR_INPUT_VAT" => $purchaseCurInputVat,
                    "DBL_PURCHASE_CUR_OUTPUT_VAT" => $purchaseCurOutputVat,
                    "DBL_PURCHASE_CUR_TOTAL_TAX" => $purchaseCurTotalTax,
                    "DBL_PURCHASE_CUR_SUPPLIER_AMOUNT" => $purchaseCurSupplierAmount,
                    "DBL_SELLING_CUR_SERVICE_FEE" => $sellingCurServiceFee,
                    "DBL_SELLING_CUR_PRICE" => $sellingCurPrice,
                    "Room_Details" => $Room_Details
                ]
            ]
        ];

        return [
            'endPointUrl' => $traacsEndPointUrl,
            'payload' => $traacsPayload
        ];
    }

    public function getRefundVoucherPayloadWithEndPointUrl($bookingId) {
        $bookingDetails = Bookings::where('id', $bookingId)->first()->toArray();
        $bookingPayloadDetails = json_decode($bookingDetails['booking_details'], true);

        $supplierConfNumber = str_replace('REH', 'HT', $bookingDetails['rehtle_ref']);
        $country = $bookingPayloadDetails['hotelDetails']['hotelDetails']['country']['description']['content'];
        $city = $bookingDetails['billing_city'];
        $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['name']['content'];
        $checkInDate = $bookingPayloadDetails['searchDetails']['stay']['checkIn'];
        $checkOutDate = $bookingPayloadDetails['searchDetails']['stay']['checkOut'];
        $guestName = ($bookingPayloadDetails['hotelDetails']['selectedRooms']['holder']['name'].' '.$bookingPayloadDetails['hotelDetails']['selectedRooms']['holder']['surname']);

        $roomNameBoardDetails = [];
        foreach($bookingPayloadDetails['hotelDetails']['hotelDetails']['rooms'] as $key => $room) {
            foreach($room['rates'] as $rate) {
                $roomNameBoardDetails[$rate['rateKey']] = [
                    'roomName' => ucwords($room['name']),
                    'boardCode' => $rate['boardCode'],
                    'boardName' => $rate['boardName'],
                    'displayNet' => $rate['displayNet'],
                    'adults' => $rate['adults'],
                    'children' => $rate['children'],
                ];
            }
        }
        $numberOfRooms = $totalAdults = $totalChildren = 0;
        foreach($bookingPayloadDetails['searchDetails']['occupancies'] as $occupancy) {
            $numberOfRooms += $occupancy['rooms'];
            $totalAdults += $occupancy['adults'];
            $totalChildren += $occupancy['children'];
        }

        $checkInDateTs = strtotime($checkInDate);
        $checkOutDateTs = strtotime($checkOutDate);
        $checkDiff = $checkOutDateTs - $checkInDateTs;
        $numberOfNights = round($checkDiff / 86400);

        $bookedRooms = $Room_Details = [];
        $roomsCount = count($bookingPayloadDetails['hotelDetails']['selectedRooms']['rooms']);
        $providerNetPrice = $bookingPayloadDetails['processedPrice']['totalPrice'];
        $purchaseCurInputVat = ($providerNetPrice * 0.15);
        $purchaseCurTotalFare = $providerNetPrice;
        $purchaseCurSupplierAmount = $providerNetPrice + $purchaseCurInputVat;
        $purchaseCurTotalTax = $purchaseCurInputVat;
        $purchaseCurOutputVat = $bookingPayloadDetails['processedPrice']['vat'];
        $sellingCurServiceFee = $bookingPayloadDetails['processedPrice']['markupServiceFee'];
        $sellingCurPrice = $purchaseCurTotalFare + $sellingCurServiceFee;

        $roomPurchaseCurRatePerNight = $purchaseCurTotalFare / $roomsCount;
        $roomPurchaseCurTaxPerNight = $purchaseCurTotalTax / $roomsCount;
        $roomPurchaseCurSupplierAmount = $purchaseCurSupplierAmount / $roomsCount;
        $roomSellingCurServiceFee = $sellingCurServiceFee / $roomsCount;
        $roomSellingCurPrice = $sellingCurPrice / $roomsCount;

        foreach($bookingPayloadDetails['hotelDetails']['selectedRooms']['rooms'] as $key => $selectedRoom) {
            $bookedRooms[$key] = [
                'room' => ('Room '.($key + 1)),
                'roomName' => $roomNameBoardDetails[$selectedRoom['rateKey']]['roomName'],
                'boardName' => $roomNameBoardDetails[$selectedRoom['rateKey']]['boardName'],
                'paxes' => $selectedRoom['paxes'],
                'rateComments' => '',
            ];

            array_push($Room_Details, [
                "STR_CHECK_IN_DATE" => date('d-m-Y', strtotime($checkInDate)),
                "STR_CHECK_OUT_DATE" => date('d-m-Y', strtotime($checkOutDate)),
                "INT_NO_OF_ROOMS" => 1,
                "INT_NO_OF_NIGHTS" => $numberOfNights,
                "STR_MEALS_PLAN" => "FB",
                "STR_TRAVELER_ID" => "",
                "STR_GUESTS" => $guestName,
                "STR_ADDITIONAL_GUESTS" => "",
                "STR_ROOM_TYPE" => $roomNameBoardDetails[$selectedRoom['rateKey']]['roomName'],
                "INT_ADULT" => $roomNameBoardDetails[$selectedRoom['rateKey']]['adults'],
                "INT_CHILD" => $roomNameBoardDetails[$selectedRoom['rateKey']]['children'],
                "DBL_PURCHASE_CUR_SUP_COMMISION" => 0,
                "DBL_SELLING_CUR_EXTRA_EARNING" => 0,
                "DBL_SELLING_CUR_PAYBACK_AMOUNT" => 0,
                "DBL_SELLING_CUR_CC_CHARGES" => 0,
                "DBL_SELLING_CUR_DISCOUNT" => 0,
                "DBL_PURCHASE_CUR_RATE_PER_NIGHT" => $roomPurchaseCurRatePerNight,
                "DBL_PURCHASE_CUR_TAX_PER_NIGHT" => $roomPurchaseCurTaxPerNight,
                "DBL_PURCHASE_CUR_SUPPLIER_AMOUNT" => $roomPurchaseCurSupplierAmount,
                "DBL_SELLING_CUR_SERVICE_FEE" => $roomSellingCurServiceFee,
                "DBL_SELLING_CUR_PRICE" => $roomSellingCurPrice
            ]);
        }
        $roomBoardType = $bookedRooms[0]['roomName'];

        if (env('APP_ENV') == 'production') {
            $traacsEndPointUrl = env('TRAACS_PRODUCTION_REFUND_ENDPOINT');
            $userName = env('TRAACS_PRODUCTION_USER_NAME');
            $password = env('TRAACS_PRODUCTION_PASSWORD');
            $costCenterCode = env('TRAACS_PRODUCTION_COST_CENTRE_CODE');
            $departmentCode = env('TRAACS_PRODUCTION_DEPARTMENT_CODE');
            $accountCode = env('TRAACS_PRODUCTION_ACCOUNT_CODE');
            $supplierCode = env('TRAACS_PRODUCTION_STR_SUPPLIER_CODE');
            $staff = env('TRAACS_PRODUCTION_STAFF');
            $staffEmailId = env('TRAACS_PRODUCTION_STAFF_EMAIL_ID');
        } else {
            $traacsEndPointUrl = env('TRAACS_DEMO_REFUND_ENDPOINT');
            $userName = env('TRAACS_DEMO_USER_NAME');
            $password = env('TRAACS_DEMO_PASSWORD');
            $costCenterCode = env('TRAACS_DEMO_COST_CENTRE_CODE');
            $departmentCode = env('TRAACS_DEMO_DEPARTMENT_CODE');
            $accountCode = env('TRAACS_DEMO_ACCOUNT_CODE');
            $supplierCode = env('TRAACS_DEMO_STR_SUPPLIER_CODE');
            $staff = env('TRAACS_DEMO_STAFF');
            $staffEmailId = env('TRAACS_DEMO_STAFF_EMAIL_ID');
        }

        $traacsPayload = [
            "str_authentication_key" => [
                "STR_AUTHENTICATION" => "",
                "STR_USER_NAME" => $userName,
                "STR_PASSWORD" => $password
            ],
            "json_master" => [
                "STR_DOCUMENT_NO" => "",
                "STR_ACTION" => "NEW OR UPDATE",
                "STR_REFUND_DATE" => date('d/m/Y'),
                "STR_COST_CENTRE_CODE" => $costCenterCode,
                "STR_DEPARTMENT_CODE" => $departmentCode,
                "DBL_SELLING_ROE" => 1,
                "STR_SELLING_CUR_CODE" => $bookingDetails['customer_currency'],
                "STR_ACCOUNT_CODE" => $accountCode
            ],
            "json_Hotel" => [
                [
                    "STR_VOUCHER_NO" => $bookingDetails['booking_ref'],
                    "STR_REFUND_DATE" => date('d/m/Y'),
                    "STR_SUPPLIER_CODE" => $supplierCode,
                    "STR_SUPPLIER_CONF_NUMBER" => $supplierConfNumber,
                    "STR_COUNTRY" => $country,
                    "STR_CITY" => $city,
                    "STR_HOTEL_NAME" => $hotelName,
                    "STR_ROOM_TYPE" => $roomBoardType,
                    "STR_MEALS_PLAN" => "FB",
                    "STR_CHECK_IN_DATE" => date('d-m-Y', strtotime($checkInDate)),
                    "STR_CHECK_OUT_DATE" => date('d-m-Y', strtotime($checkOutDate)),
                    "STR_HOTEL_CONF_NUMBER" => "",
                    "STR_PNR_NO" => "",
                    "STR_LPO_NO" => "Reconfirmed ".$hotelName,
                    "STR_TRAVELER_ID" => "",
                    "STR_GUESTS" => $guestName,
                    "STR_ADDITIONAL_GUESTS" => "",
                    "INT_NO_OF_ROOMS" => $numberOfRooms,
                    "INT_NO_OF_NIGHTS" => $numberOfNights,
                    "STR_PURCHASE_CUR_CODE" => $bookingDetails['customer_currency'],
                    "STR_REFUND_STATUS" => 'Refund',
                    "STR_REFUND_STAFF" => $staff,
                    "STR_REFUND_STAFF_EMAIL_ID" => $staffEmailId,
                    "STR_ORIGIN_COUNTRY" => "",
                    "STR_REMARKS" => "",
                    "STR_BOOKING_DETAILS" => "",
                    "STR_TAX_DETAILS" => "",
                    "DBL_SELLING_CUR_EXTRA_EARNING" => 0,
                    "DBL_SELLING_CUR_PAYBACK_AMOUNT" => 0,
                    "STR_PAYBACK_ACCOUNT_CODE" => "",
                    "DBL_SELLING_CUR_CC_CHARGES" => 0,
                    "DBL_SELLING_CUR_DISCOUNT" => 0,
                    "DBL_PURCHASE_CUR_SUP_COMMISION" => 0,
                    "DBL_PURCHASE_CUR_SUPPLIER_FEE" => 0,
                    "DBL_PURCHASE_CUR_TOTAL_FARE" => $purchaseCurTotalFare,
                    "DBL_PURCHASE_CUR_INPUT_VAT" => $purchaseCurInputVat,
                    "DBL_PURCHASE_CUR_OUTPUT_VAT" => $purchaseCurOutputVat,
                    "DBL_PURCHASE_CUR_TOTAL_TAX" => $purchaseCurTotalTax,
                    "DBL_PURCHASE_CUR_SUPPLIER_AMOUNT" => $purchaseCurSupplierAmount,
                    "DBL_SELLING_CUR_SERVICE_FEE" => $sellingCurServiceFee,
                    "DBL_SELLING_CUR_PRICE" => $sellingCurPrice,
                    "Room_Details" => $Room_Details
                ]
            ]
        ];

        return [
            'endPointUrl' => $traacsEndPointUrl,
            'payload' => $traacsPayload
        ];
    }

    public function createVoucherInTraacs($bookingId) {
       
        $traacsPayloadWithEndPointUrl = $this->getCreateVoucherPayloadWithEndPointUrl($bookingId);
        $traacsEndPointUrl = $traacsPayloadWithEndPointUrl['endPointUrl'];
        $traacsPayload = $traacsPayloadWithEndPointUrl['payload'];

        $traacsResponse = $this->libCurl($traacsEndPointUrl, 'POST', [], $traacsPayload);
        $traacsResponse['payload'] = $traacsPayload;
        $traacsData = $traacsResponse['data'] ?? null;
        if (is_string($traacsData)) {
        $traacsData = json_decode($traacsData, true);
        }

        $traacsRequestPayload = [
            'booking_id' => $bookingId,
            'traacs_no' => $traacsData['NO'] ?? null,
            'traacs_booking_id' => '',
            'log_type' => 'Create Voucher',
            'supplier_code' => '',
            'request_payload' => json_encode($traacsPayload),
            'status' => $traacsData['STATUS'] ?? null,
            'message' => $traacsData['MESSAGE'] ?? null
        ];
        if (isset($traacsResponse['data']['BOOKING_ID'])) {
            $traacsRequestPayload['traacs_booking_id'] = $traacsData['BOOKING_ID'];
            $traacsRequestPayload['supplier_code'] = $traacsData['SUPP_CODE'] ?? '';
        }
        TraacsLog::createTraacsLog($traacsRequestPayload);

        return $traacsResponse;
    }

    public function refundVoucherInTraacs($bookingId) {
        $traacsPayloadWithEndPointUrl = $this->getRefundVoucherPayloadWithEndPointUrl($bookingId);
        $traacsEndPointUrl = $traacsPayloadWithEndPointUrl['endPointUrl'];
        $traacsPayload = $traacsPayloadWithEndPointUrl['payload'];

        $traacsResponse = $this->libCurl($traacsEndPointUrl, 'POST', [], $traacsPayload);
        $traacsResponse['payload'] = $traacsPayload;

        $traacsRequestPayload = [
            'booking_id' => $bookingId,
            'traacs_no' => $traacsResponse['data']['NO'],
            'traacs_booking_id' => '',
            'log_type' => 'Refund Voucher',
            'supplier_code' => '',
            'request_payload' => json_encode($traacsPayload),
            'status' => $traacsResponse['data']['STATUS'],
            'message' => $traacsResponse['data']['MESSAGE']
        ];
        if (isset($traacsResponse['data']['BOOKING_ID'])) {
            $traacsRequestPayload['traacs_booking_id'] = $traacsResponse['data']['BOOKING_ID'];
            $traacsRequestPayload['supplier_code'] = $traacsResponse['data']['SUPP_CODE'];
        }
        TraacsLog::createTraacsLog($traacsRequestPayload);

        return $traacsResponse;
    }

}
