<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use Illuminate\Support\Str;
use Carbon\Carbon;
use Config;

trait PaymentService {
    use CommonService;
    public function getPaymentType($paymentBrand) {
        $paymentTypeMap = [
            'MADA' => 'PA',
            'VISA' => 'PA',
            'MASTER' => 'PA',
            'AMEX' => 'PA',
            'APPLEPAY' => 'PA',
            'STC_PAY' => 'DB',
            'SADAD_VA' => 'DB',
            'TABBY' => 'DB'
        ];
        if (in_array($paymentBrand, array_keys($paymentTypeMap))) {
            return $paymentTypeMap[$paymentBrand];
        } else {
            return 'PA';
        }
    }

    public function isCapturePayment($paymentBrand) {
        $paymentTypeMapPaymentBrands = ['MADA', 'VISA', 'MASTER', 'AMEX', 'APPLEPAY'];
        if (in_array($paymentBrand, $paymentTypeMapPaymentBrands)) {
            return true;
        }
        return false;
    }

    public function getPaymentSettings($paymentBrand ='') {
        $settings = [
            'url' => env('HYPER_PAY_URL'),
            'checkoutUrl' => env('HYPER_PAY_CHECKOUT_URL'),
            'entityId' => [
                'MADA' => env('HYPER_PAY_ENTITY_ID_MADA'),
                'VISA' => env('HYPER_PAY_ENTITY_ID_VISA'),
                'MASTER' => env('HYPER_PAY_ENTITY_ID_MASTER'),
                'AMEX' => env('HYPER_PAY_ENTITY_ID_AMEX'),
                'APPLEPAY' => env('HYPER_PAY_ENTITY_ID_APPLEPAY'),
                'STC_PAY' => env('HYPER_PAY_ENTITY_ID_STC_PAY'),
                'SADAD_VA' => env('HYPER_PAY_ENTITY_ID_SADAD_VA'),
                'TABBY' => env('HYPER_PAY_ENTITY_ID_TABBY'),
            ],
            'authHeader' => 'Authorization:Bearer '.env('HYPER_PAY_TOKEN'),
            'shopperResultUrl' => env('APP_URL_PROTOCOL').env('APP_URL').'/home',
            'paymentType' => ''
        ];
        if ($paymentBrand != '') {
            $settings['paymentType'] = $this->getPaymentType($paymentBrand);
        }
        return $settings;
    }

    public function processPayment($paymentDetails, $paymentType = 'PA', $cardType = 'VISA', $paymentData = []) {
        $result = [
            'status' => 'false',
            'response' => '',
            'message' => ''
        ];
        $paymentSettings = $this->getPaymentSettings();
        $postData = [
            'entityId' => $paymentSettings['entityId'][$cardType],
            'shopperResultUrl' => $paymentSettings['shopperResultUrl']
        ];
        foreach($paymentDetails as $key => $paymentDetail) {
            $postData[$key] = $paymentDetail;
        }
        $paymentUrl = $paymentSettings['url'];
        if ($paymentType == 'CP' || $paymentType == 'RV') {
            $paymentUrl = $paymentUrl . '/' . $paymentData['pre_authorization_id'];
        }

        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $paymentUrl);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array($paymentSettings['authHeader']));
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // this should be set to true in production
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = curl_exec($ch);

        // if(curl_errno($ch)) {
        //     $result['message'] = curl_error($ch);
        // } else {
        //     $result['status'] = 'true';
        //     $result['data'] = json_decode($response);
        // }
        // curl_close($ch);
        $result = $this->libCurl($paymentUrl, 'POST', [$paymentSettings['authHeader']],http_build_query($postData));
        return $result;
    }

    public function getPaymentCheckoutId($paymentPayload) {
        $result = [
            'status' => 'false',
            'data' => '',
            'message' => '',
			'request' => '',
			'response' => ''
        ];
        $successPattern = '/^(000\.000\.|000\.100\.1|000\.[36])/';
        $successManualReviewCodePattern = '/^(000\.400\.0|000\.400\.100)/';

        $paymentSettings = $this->getPaymentSettings($paymentPayload['paymentBrand']);
        $paymentPayload['entityId'] = $paymentSettings['entityId'][$paymentPayload['paymentBrand']];
        $paymentPayload['paymentType'] = $paymentSettings['paymentType'];
        unset($paymentPayload['paymentBrand']);

        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $paymentSettings['checkoutUrl']);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, [$paymentSettings['authHeader']]);
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($paymentPayload));
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = curl_exec($ch);
		
        $result = $this->libCurl($paymentSettings['checkoutUrl'], 'POST', [$paymentSettings['authHeader']],http_build_query($paymentPayload));
		$result['request'] = $paymentPayload;
		$result['response'] = $result;

        if(!$result['status']) {
            // $result['message'] = curl_error($ch);
            return $result;
        } else {
            $success = false;
            // $response = json_decode($response, true);
            // $resultCode = $response['result']['code'];
            $response = $result['data'];
            $resultCode = $result['http_code'];
            if ($paymentSettings['paymentType'] == 'PA' && isset($response['id']) && $resultCode == '000.200.100') {
                $success = true;
            } elseif ($paymentSettings['paymentType'] == 'DB' && isset($response['id']) &&
                (preg_match($successPattern , $resultCode) || preg_match($successManualReviewCodePattern , $resultCode) || $resultCode == '000.200.100')
            ) {
                $success = true;
            }
            if ($success) {
                $result['status'] = 'true';
                $result['data'] = $response;
            } else{
                $result['data'] = $response;
                //$result['message'] = $response;
                $result['message'] = $response['result']['code'].' - '.$response['result']['description'];
                if (isset($response['result']['parameterErrors']) && is_array($response['result']['parameterErrors'])) {
                    $messages = [];
                    foreach($response['result']['parameterErrors'] as $error) {
                        $message = $error['value'].': '.$error['name'].' '.$error['message'];
                        array_push($messages, $message);
                    }
                    if (count($messages) > 0) {
                        $result['message'] = implode(',', $messages);
                    }
                }
            }
        }
        // curl_close($ch);
        //echo "<pre>"; print_r($result); die;

        return $result;
    }

    public function getPaymentStatus($paymentBrand, $paymentId) {
        $result = [
            'status' => 'false',
            'data' => '',
            'message' => ''
        ];
        $paymentSettings = $this->getPaymentSettings($paymentBrand);
		if (array_key_exists('entityId', $paymentSettings)) {
			$entityId = $paymentSettings['entityId'][$paymentBrand];
			$statusUrl = $paymentSettings['checkoutUrl'].'/'.$paymentId.'/payment?entityId='.$entityId;

			// $ch = curl_init();
			// curl_setopt($ch, CURLOPT_URL, $statusUrl);
			// curl_setopt($ch, CURLOPT_HTTPHEADER, [$paymentSettings['authHeader']]);
			// curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
			// curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// $response = curl_exec($ch);

			// if(curl_errno($ch)) {
			// 	$result['message'] = curl_error($ch);
			// } else {
			// 	$result['status'] = 'true';
			// 	$result['data'] = json_decode($response, true);
			// }
			// curl_close($ch);
            $result = $this->libCurl($statusUrl, 'GET', [$paymentSettings['authHeader']]);
		}

        return $result;
    }

    public function capturePayment($preAuthId, $paymentBrand, $amount, $currency) {
        $result = [
            'status' => 'false',
            'response' => '',
            'message' => ''
        ];
        $paymentSettings = $this->getPaymentSettings();
        $postData = [
            'entityId' => $paymentSettings['entityId'][$paymentBrand],
            'amount' => $amount,
            'currency' => $currency,
            'paymentType' => 'CP'

        ];
        $paymentUrl = $paymentSettings['url']. '/' . $preAuthId;

        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $paymentUrl);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array($paymentSettings['authHeader']));
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // this should be set to true in production
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = curl_exec($ch);

        // if(curl_errno($ch)) {
        //     $result['message'] = curl_error($ch);
        // } else {
        //     $result['status'] = 'true';
        //     $result['data'] = json_decode($response, true);
        // }
        // curl_close($ch);
        $result = $this->libCurl($paymentUrl, 'POST', [$paymentSettings['authHeader']],http_build_query($postData));
        return $result;
    }

    public function revertPayment($preAuthId, $paymentBrand) {
        $result = [
            'status' => 'false',
            'response' => '',
            'message' => ''
        ];
        $paymentSettings = $this->getPaymentSettings();
        $postData = [
            'entityId' => $paymentSettings['entityId'][$paymentBrand],
            'paymentType' => 'RV'

        ];
        $paymentUrl = $paymentSettings['url']. '/' . $preAuthId;

        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $paymentUrl);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array($paymentSettings['authHeader']));
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // this should be set to true in production
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = curl_exec($ch);

        // if(curl_errno($ch)) {
        //     $result['message'] = curl_error($ch);
        // } else {
        //     $result['status'] = 'true';
        //     $result['data'] = json_decode($response, true);
        // }
        // curl_close($ch);
        $result = $this->libCurl($paymentUrl, 'POST', [$paymentSettings['authHeader']],http_build_query($postData));
        return $result;
    }

    public function refundPayment($paymentId, $paymentBrand, $processedCancelAmount, $currency) {
        $result = [
            'status' => 'false',
            'response' => '',
            'message' => ''
        ];
        $successPattern = '/^(000\.000\.|000\.100\.1|000\.[36])/';
        $successManualReviewCodePattern = '/^(000\.400\.0|000\.400\.100)/';

        $paymentSettings = $this->getPaymentSettings();
        $postData = [
            'entityId' => $paymentSettings['entityId'][$paymentBrand],
            'amount' => $processedCancelAmount,
            'paymentType' => 'RF',
            'currency' => $currency,

        ];
        $paymentUrl = $paymentSettings['url']. '/' . $paymentId;

        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $paymentUrl);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array($paymentSettings['authHeader']));
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // this should be set to true in production
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = curl_exec($ch);
        $result = $this->libCurl($paymentUrl, 'POST', [$paymentSettings['authHeader']],http_build_query($postData));
        if(!$result['status']) {
            // $result['message'] = curl_error($ch);
            return $result;
        } else {
            // $response = json_decode($response, true);
            // $responseCode = $response['result']['code'];
            $response = $result['data'];
            $responseCode = $result['http_code'];
            // $result['data'] = $response;
            if (preg_match($successPattern , $responseCode) || preg_match($successManualReviewCodePattern , $responseCode) || $responseCode == '000.200.100') {
                $result['status'] = 'true';
            }
        }
        // curl_close($ch);
       
        return $result;
    }

	public function getSeatmapFlightOffers($bookingDetails) {
		if (
            array_key_exists('seatDetails', $bookingDetails['flightDetails']) &&
            $bookingDetails['flightDetails']['seatDetails']['status'] == true
        ) {
            $seatDetailsByTravelerAndSegment = [];
			$seatPrice = 0;
			if ($bookingDetails['flightDetails']['seatDetails']['status']) {
				$seatDetails = $bookingDetails['flightDetails']['seatDetails']['seatDetails'];
				foreach ($seatDetails as $seatDetail) {
					$seatNumber = $seatDetail['ticket_details']['seat_number'];
					if ($seatNumber != '' && $seatNumber != 'null') {
						$seatDetailsByTravelerAndSegment[$seatDetail['travelerId']][$seatDetail['segmentId']] = $seatNumber;
						foreach ($seatDetail['price_details']['allPriceDetails'] as $allPriceDetail) {
							$seatPrice += $allPriceDetail['price']['total'];
						}
					}
				}
				foreach ($bookingDetails['flightDetails']['flightInfo'] as &$flightOffer) {
					$seatMapAdded = false;
					foreach ($flightOffer['travelerPricings'] as &$travelerPricing) {
						foreach ($travelerPricing['fareDetailsBySegment'] as &$fareDetailsBySegment) {
							if (array_key_exists($travelerPricing['travelerId'], $seatDetailsByTravelerAndSegment)) {
								if (array_key_exists($fareDetailsBySegment['segmentId'], $seatDetailsByTravelerAndSegment[$travelerPricing['travelerId']])) {
									if (array_key_exists('additionalServices', $fareDetailsBySegment) == false) {
										$fareDetailsBySegment['additionalServices'] = [];
									}
									$seatNumber = $seatDetailsByTravelerAndSegment[$travelerPricing['travelerId']][$fareDetailsBySegment['segmentId']];
									$fareDetailsBySegment['additionalServices']['chargeableSeatNumber'] = $seatNumber;
									$seatMapAdded = true;
								}
							}
						}
					}
					if ($seatMapAdded) {
						$flightOffer['price']['grandTotal'] = $flightOffer['price']['grandTotal'] + $seatPrice;
					}
				}
			}
		}
		return $bookingDetails;
	}
}
