<?php

namespace App\Traits;

use Spatie\Activitylog\LogOptions;

trait LogsActivityDefaults
{
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName($this->getLogName())
            ->setDescriptionForEvent(fn(string $eventName) => $this->getDescriptionForEvent($eventName));
    }

    protected function getLogName(): string
    {
        return class_basename($this); 
    }

    protected function getDescriptionForEvent(string $eventName): string
    {
        return class_basename($this) . " was {$eventName}";
    }
}
