<?php 

namespace App\Traits;

use Spatie\Activitylog\LogOptions;

trait HasActivityLogging
{
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName(static::$logName ?? class_basename($this))
            ->setDescriptionForEvent(
                fn (string $eventName) => class_basename($this)." model has been {$eventName}"
            );
    }
}
