<?php

namespace App\Traits;

use App\Enums\Currency;
use App\Models\Markups;
use App\Models\DefaultMarkup;
use App\Models\MarkupSetting;
use App\Traits\LoyaltyPointsService;

trait FlightListMarkup
{
    use LoyaltyPointsService;
    // Process Markup for Flight List
    public function getFlightListMarkup($flightList, $requestData)
    {

        $markupSetting = MarkupSetting::first();
        // $requestData['searchFrom'] = 'b2c_desktop';
        if ($markupSetting && $markupSetting->apply_markup_flight_list == 1) {
            $markups = Markups::with('getChannel')->where('service_type_id', 1)->orderByDesc('priority')->get()->toArray();
            $defaultMarkups = DefaultMarkup::where('service_type_id', 1)->get()->toArray();
            $bookingDate = date('Y-m-d');

            $markupDetails = [];

            if (!empty($markups) && !empty($requestData['originDestinations'])) {
                foreach ($requestData['originDestinations'] as $originDestination) {
                    $departureDate = $originDestination['departureDate'] ?? null;
                    $originLocationCode = $originDestination['originLocationCode'] ?? null;
                    $destinationLocationCode = $originDestination['destinationLocationCode'] ?? null;

                    if ($departureDate && $originLocationCode && $destinationLocationCode) {
                        foreach ($markups as $markup) {
                            // Check for matching channel
                            $hasMatchingChannel = false;
                            if (!empty($markup['get_channel'])) {
                                foreach ($markup['get_channel'] as $channel) {
                                    if ($channel['channel'] == $requestData['searchFrom']) {
                                        $hasMatchingChannel = true;
                                        break;
                                    }
                                }
                            }

                            if (!$hasMatchingChannel) {
                                continue;
                            }

                            if (
                                (
                                    ($departureDate >= $markup['from_travel_date'] && $departureDate <= $markup['to_travel_date']) &&
                                    ($destinationLocationCode == $markup['destination_name'] && $originLocationCode == $markup['origin_name'])
                                )
                                ||
                                (
                                    ($departureDate >= $markup['from_travel_date'] && $departureDate <= $markup['to_travel_date']) &&
                                    ($markup['origin_criteria'] == 'all' && $markup['destination_criteria'] == 'all')
                                )
                            ) {
                                $markupDetails[] = [
                                    'type' => $markup['b2c_markup_type'],
                                    'from_amount' => (float) $markup['from_price_range'],
                                    'to_amount' => (float) $markup['to_price_range'],
                                    'b2c_amount' => (float) $markup['b2c_markup'],
                                ];
                            }
                        }
                    }
                }
            }



            if (!empty($flightList['data'])) {
                foreach ($flightList['data'] as &$flightOffer) {
                    if (isset($flightOffer['processed']['price'])) {
                        $price = (float) $flightOffer['processed']['price']['total'];
                        $grandTotal = (float) $flightOffer['processed']['price']['grandTotal'];
                        $markupApplied = false;
                        $highestMarkupAmount = 0;

                        $flightOffer['processed']['price']['beforePrice'] = $price;


                        foreach ($markupDetails as $markup) {
                            if (($markup['from_amount'] == 0 && $markup['to_amount'] == 0) ||
                                ($price >= $markup['from_amount'] && $price <= $markup['to_amount']) ||
                                ($grandTotal >= $markup['from_amount'] && $grandTotal <= $markup['to_amount'])
                            ) {
                                $currentMarkupAmount = ($markup['type'] === 'percentage')
                                    ? ($price * $markup['b2c_amount']) / 100
                                    : $markup['b2c_amount'];

                                if ($currentMarkupAmount > $highestMarkupAmount) {
                                    $highestMarkupAmount = $currentMarkupAmount;
                                    $markupApplied = true;
                                }
                            }
                        }

                        if ($markupApplied) {
                            $flightOffer['processed']['price']['total'] = round((float) $price + (float) $highestMarkupAmount, 2);
                            $flightOffer['processed']['price']['grandTotal'] = round((float)$grandTotal + (float)$highestMarkupAmount, 2);

                            $hotel['Points'] = round((float)$price + (float) $highestMarkupAmount, 2);
                            $convertedLoyaltyPoints = $requestData['currency'] == Currency::USD->value ? getConvertedCurrencyValue($hotel['Points'], Currency::USD->value,Currency::SAR->value) : getConvertedCurrencyValue($hotel['Points'], Currency::SAR->value, Currency::SAR->value);
                            $hotel['Points'] = $convertedLoyaltyPoints['data'] ?? '';

                            $flightOffer['processed']['price']['defaultMarkup'] = 'no';
                            if (isset($flightOffer['processed']['brandedFare']['brandedFares'])) {
                                foreach ($flightOffer['processed']['brandedFare']['brandedFares'] as &$brandedFares) {
                                    $brandedFares['price'] = round((float) $grandTotal + (float) $highestMarkupAmount, 2);
                                }
                            }
                        } else {
                            foreach ($defaultMarkups as $defaultMarkup) {
                                $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                                    ? ($price * $defaultMarkup['b2c_markup']) / 100
                                    : $defaultMarkup['b2c_markup'];

                                $flightOffer['processed']['price']['total'] = round((float)$price + (float)$defaultMarkupAmount, 2, 2);
                                $flightOffer['processed']['price']['grandTotal'] = round((float)$grandTotal + (float)$defaultMarkupAmount, 2);
                                $flightOffer['processed']['price']['defaultMarkup'] = 'yes';

                                if (isset($flightOffer['processed']['brandedFare']['brandedFares'])) {
                                    foreach ($flightOffer['processed']['brandedFare']['brandedFares'] as &$brandedFares) {
                                        $brandedFares['price'] = round((float) $grandTotal + (float) $defaultMarkupAmount, 2);
                                    }
                                }
                                break;
                            }
                        }
                        $payload = [
                            'service' => 'Airline Ticket',
                            'amount' => $flightOffer['processed']['price']['grandTotal'],
                            'fromCurrency' => Currency::SAR->value,
                            'toCurrency' => $requestData['currencyCode']
                        ];
                        $loyaltyPoints = $this->getLoyaltyPoints($payload);

                        $flightOffer['processed']['price']['rehlte_points'] = $loyaltyPoints;
                    }
                }
            }
        }
        return $flightList;
    }

    // Process Markup for Flight Upselling)
    public function getFlightUpsellingMarkup($flightOffersData, $requestData)
    {
        // $requestData['searchFrom'] = 'b2c_desktop';
        $markupSetting = MarkupSetting::first();
        if ($markupSetting && $markupSetting->apply_markup_flight_list == 1) {
            $markups = Markups::with('getChannel')->where('service_type_id', 1)->orderByDesc('priority')->get()->toArray();
            $defaultMarkups = DefaultMarkup::where('service_type_id', 1)->get()->toArray();
            $bookingDate = date('Y-m-d');

            $markupDetails = [];
            if (!empty($markups) && !empty($requestData['itineraries'])) {

                $ticketingDate = $requestData['lastTicketingDate'] ?? null;
                $originLocationCode = $requestData['itineraries'][0]['segments'][0]['departure']['iataCode'] ?? null;
                $destinationLocationCode = $requestData['itineraries'][0]['segments'][0]['arrival']['iataCode'] ?? null;

                if ($ticketingDate && $originLocationCode && $destinationLocationCode) {
                    foreach ($markups as $markup) {

                        // Check if searchFrom matches a channel
                        $hasMatchingChannel = false;
                        if (!empty($markup['get_channel'])) {
                            foreach ($markup['get_channel'] as $channel) {
                                if ($channel['channel'] == $requestData['searchFrom']) {
                                    $hasMatchingChannel = true;
                                    break;
                                }
                            }
                        }

                        if (!$hasMatchingChannel) {
                            continue;
                        }

                        if (
                            (
                                ($ticketingDate >= $markup['from_travel_date'] && $ticketingDate <= $markup['to_travel_date']) &&
                                ($destinationLocationCode == $markup['destination_name'] && $originLocationCode == $markup['origin_name'])
                            )
                            ||
                            (
                                ($ticketingDate >= $markup['from_travel_date'] && $ticketingDate <= $markup['to_travel_date']) &&
                                ($markup['origin_criteria'] == 'all' && $markup['destination_criteria'] == 'all')
                            )
                        ) {
                            $markupDetails[] = [
                                'type' => $markup['b2c_markup_type'],
                                'from_amount' => (float) $markup['from_price_range'],
                                'to_amount' => (float) $markup['to_price_range'],
                                'b2c_amount' => (float) $markup['b2c_markup'],
                            ];
                        }
                    }
                }
            }


            if (!empty($flightOffersData['data'])) {
                foreach ($flightOffersData['data'] as &$flightOffer) {
                    if (isset($flightOffer['price'])) {
                        $price = (float) $flightOffer['price']['total'];
                        $grandTotal = (float) $flightOffer['price']['grandTotal'];
                        $markupApplied = false;
                        $highestMarkupAmount = 0;

                        $flightOffer['price']['beforePrice'] = $price;


                        foreach ($markupDetails as $markup) {
                            if (($markup['from_amount'] == 0 && $markup['to_amount'] == 0) ||
                                ($price >= $markup['from_amount'] && $price <= $markup['to_amount']) ||
                                ($grandTotal >= $markup['from_amount'] && $grandTotal <= $markup['to_amount'])
                            ) {
                                $currentMarkupAmount = ($markup['type'] === 'percentage')
                                    ? ($price * $markup['b2c_amount']) / 100
                                    : $markup['b2c_amount'];

                                if ($currentMarkupAmount > $highestMarkupAmount) {
                                    $highestMarkupAmount = $currentMarkupAmount;
                                    $markupApplied = true;
                                }
                            }
                        }


                        if ($markupApplied) {
                            $flightOffer['price']['total'] = round((float) $price + (float) $highestMarkupAmount, 2);
                            $flightOffer['price']['grandTotal'] = round((float) $grandTotal + (float) $highestMarkupAmount, 2);
                            $flightOffer['price']['defaultMarkup'] = 'no';
                        } else {

                            foreach ($defaultMarkups as $defaultMarkup) {
                                $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                                    ? ($price * $defaultMarkup['b2c_markup']) / 100
                                    : $defaultMarkup['b2c_markup'];

                                $flightOffer['price']['total'] = round((float) $price + (float) $defaultMarkupAmount, 2);
                                $flightOffer['price']['grandTotal'] = round((float) $grandTotal + (float) $defaultMarkupAmount, 2);
                                $flightOffer['price']['defaultMarkup'] = 'yes';

                                break;
                            }
                        }
                    }
                }
            }

            if (!empty($flightOffersData['brandedFares'])) {
                foreach ($flightOffersData['brandedFares'] as &$brandedFare) {
                    if (isset($brandedFare['price'])) {
                        $brandedPrice = (float) $brandedFare['price'];
                        $brandedFare['beforePrice'] = $brandedPrice;
                        $markupApplied = false;
                        $highestMarkupAmount = 0;
                        foreach ($markupDetails as $markup) {
                            if (($markup['from_amount'] == 0 && $markup['to_amount'] == 0) ||
                                ($brandedPrice >= $markup['from_amount'] && $brandedPrice <= $markup['to_amount']) ||
                                ($brandedPrice >= $markup['from_amount'] && $brandedPrice <= $markup['to_amount'])
                            ) {
                                $currentMarkupAmount = ($markup['type'] === 'percentage')
                                    ? ($brandedPrice * $markup['b2c_amount']) / 100
                                    : $markup['b2c_amount'];

                                if ($currentMarkupAmount > $highestMarkupAmount) {
                                    $highestMarkupAmount = $currentMarkupAmount;
                                    $markupApplied = true;
                                }
                            }
                        }

                        if ($markupApplied) {
                            $brandedFare['price'] = (float) $brandedPrice + (float) $highestMarkupAmount;
                        } else {

                            foreach ($defaultMarkups as $defaultMarkup) {
                                $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                                    ? ($brandedPrice * $defaultMarkup['b2c_markup']) / 100
                                    : $defaultMarkup['b2c_markup'];
                                $brandedFare['price'] = round((float) $brandedPrice + (float) $highestMarkupAmount, 2);
                                $flightOffer['price']['defaultMarkup'] = 'yes';

                                break;
                            }
                        }
                    }
                }
            }
        }

        if (!empty($flightOffersData['data'])) {
            foreach ($flightOffersData['data'] as &$flightOffer) {
                $payload = [
                    'service' => 'Airline Ticket',
                    'amount' => $flightOffer['price']['grandTotal'],
                    'fromCurrency' => Currency::SAR->value,
                    'toCurrency' => $flightOffer['price']['currency']
                ];
                $loyaltyPoints = $this->getLoyaltyPoints($payload);
                $flightOffer['price']['rehlte_points'] = $loyaltyPoints;
            }
        }


        return $flightOffersData;
    }


    // Markup for Processed Price
    public function getMarkupProcessedPrice($bookingDetails, $totalPrice, $requestData)
    {
        // $requestData['searchFrom'] = 'b2c_desktop';
        $updatedPriceDetails = [];
        $markupDetails = [];
        $ancillaryMarkup = [];
        if (isset($bookingDetails['bookingDetails'])) {

            if ($bookingDetails['bookingDetails']['bookingType'] == 'Flight') {
                $markups = Markups::with('getChannel')->where('service_type_id', 1)->orderByDesc('priority')->get()->toArray();
                $defaultMarkups = DefaultMarkup::where('service_type_id', 1)->get()->toArray();
                $bookingDate = date('Y-m-d');
                $markupDetails = [];
                // $ancillaryMarkup = [
                //     'ancillary_service_markup_type' => $markups['ancillary_service_markup_type'],
                //     'ancillary_service_markup' => $markups['ancillary_service_markup'],

                // ];
                if (!empty($markups) && !empty($bookingDetails['bookingDetails'])) {

                    $flightDetails = $bookingDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0];
                    $departureDate = date('Y-m-d', strtotime($flightDetails['departure']['at'])) ?? null;
                    $arrivalDate  = date('Y-m-d', strtotime($flightDetails['arrival']['at'])) ?? null;
                    $originLocationCode = $flightDetails['departure']['iataCode'] ?? null;
                    $destinationLocationCode = $flightDetails['arrival']['iataCode'] ?? null;

                    if ($departureDate && $arrivalDate && $originLocationCode && $destinationLocationCode) {
                        foreach ($markups as $markup) {

                            $hasMatchingChannel = false;
                            if (!empty($markup['get_channel'])) {
                                foreach ($markup['get_channel'] as $channel) {
                                    if ($channel['channel'] == $requestData['searchFrom']) {
                                        $hasMatchingChannel = true;
                                        break;
                                    }
                                }
                            }

                            if (!$hasMatchingChannel) {
                                continue;
                            }

                            if (
                                (
                                    ($departureDate >= $markup['from_travel_date'] && $arrivalDate <= $markup['to_travel_date']) &&
                                    ($destinationLocationCode == $markup['destination_name'] && $originLocationCode == $markup['origin_name'])
                                )
                                ||
                                (
                                    ($departureDate >= $markup['from_travel_date'] && $arrivalDate <= $markup['to_travel_date']) &&
                                    ($markup['origin_criteria'] == 'all' && $markup['destination_criteria'] == 'all')
                                )
                            ) {
                                $markupDetails[] = [
                                    'type' => $markup['b2c_markup_type'],
                                    'from_amount' => (float) $markup['from_price_range'],
                                    'to_amount' => (float) $markup['to_price_range'],
                                    'b2c_amount' => (float) $markup['b2c_markup'],
                                    'service_calculation_method' => $markup['service_calculation_method'],
                                    'ancillary_service_markup_type' => $markup['ancillary_service_markup_type'],
                                    'ancillary_service_markup' => $markup['ancillary_service_markup'],
                                ];
                            }
                        }
                    }
                }

                $updatedPriceDetails = $this->processPrice($totalPrice, $defaultMarkups, $markupDetails);


                return $updatedPriceDetails;
            } elseif ($bookingDetails['bookingDetails']['bookingType'] == 'Hotel') {
                $markups = Markups::with('getChannel')->where('service_type_id', 2)->get()->toArray();
                $defaultMarkups = DefaultMarkup::where('service_type_id', 2)->get()->toArray();
                $bookingDate = date('Y-m-d');

                $markupDetails = [];


                if (!empty($markups) && !empty($bookingDetails['bookingDetails'])) {
                    $hotelDetails = $bookingDetails['searchDetails']['stay'];

                    foreach ($markups as $markup) {

                        $hasMatchingChannel = false;
                        if (!empty($markup['get_channel'])) {
                            foreach ($markup['get_channel'] as $channel) {
                                if ($channel['channel'] == $requestData['searchFrom']) {
                                    $hasMatchingChannel = true;
                                    break;
                                }
                            }
                        }

                        if (!$hasMatchingChannel) {
                            continue;
                        }

                        if (
                            ($hotelDetails['checkIn'] >= $markup['from_travel_date'] &&
                                $hotelDetails['checkOut'] <= $markup['to_travel_date']) &&
                            ($bookingDate >= $markup['from_booking_date'] &&
                                $bookingDate <= $markup['to_booking_date'])
                        ) {
                            $markupDetails[] = [
                                'type' => $markup['b2c_markup_type'],
                                'from_amount' => (float) $markup['from_price_range'],
                                'to_amount' => (float) $markup['to_price_range'],
                                'b2c_amount' => (float) $markup['b2c_markup'],
                            ];
                        }
                    }
                }


                $updatedPriceDetails = $this->processPrice($totalPrice, $defaultMarkups, $markupDetails);
                return $updatedPriceDetails;
            }
        }
    }


    public function processPrice($totalPrice, $defaultMarkups, $markupDetails)
    {
        $updatedPriceDetails = [];
        if ($totalPrice != '') {
            $price = (float) $totalPrice;
            $markupApplied = false;
            $highestMarkupAmount = 0;
            $markupType = null;
            $markupValue = 0;
            $serviceCalculationMethod = 'from_total';
            $ancillaryServiceMarkupType = '';
            $ancillaryServiceMarkup = 0;

            // Find highest ancillary markup amount across all markups
            $highestAncillaryAmount = 0;
            foreach ($markupDetails as $markup) {
                $ancillaryAmount = isset($markup['ancillary_service_markup']) ? (float)$markup['ancillary_service_markup'] : 0;
                if ($ancillaryAmount > $highestAncillaryAmount) {
                    $highestAncillaryAmount = $ancillaryAmount;
                    $ancillaryServiceMarkupType = $markup['ancillary_service_markup_type'] ?? '';
                }
            }

            // Main markup logic
            foreach ($markupDetails as $markup) {
                if (
                    ($markup['from_amount'] == 0 && $markup['to_amount'] == 0) ||
                    ($price >= $markup['from_amount'] && $price <= $markup['to_amount'])
                ) {
                    $currentMarkupAmount = ($markup['type'] === 'percentage')
                        ? ($price * $markup['b2c_amount']) / 100
                        : $markup['b2c_amount'];

                    $markupType = $markup['type'];
                    $markupValue = $markup['b2c_amount'];
                    $serviceCalculationMethod = $markup['service_calculation_method'] ?? 'from_total';

                    if ($currentMarkupAmount > $highestMarkupAmount) {
                        $highestMarkupAmount = $currentMarkupAmount;
                        $markupApplied = true;
                    }
                }
            }

            if ($markupApplied) {
                $updatedPriceDetails = [
                    'totalPrice' => (float) $price + (float) $highestMarkupAmount,
                    'defaultMarkup' => 'no',
                    'markupType' => $markupType,
                    'beforePrice' => $price,
                    'markupValue' => $markupValue,
                    'markupFee' => $highestMarkupAmount,
                    'service_calculation_method' => $serviceCalculationMethod,
                    'ancillary_service_markup_type' => $ancillaryServiceMarkupType ?? '',
                    'ancillary_service_markup' => $highestAncillaryAmount ?? 0,
                ];
            } else {
                foreach ($defaultMarkups as $defaultMarkup) {
                    $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                        ? ($price * $defaultMarkup['b2c_markup']) / 100
                        : $defaultMarkup['b2c_markup'];
                    $updatedPriceDetails = [
                        'totalPrice' => round((float) $price + (float) $defaultMarkupAmount, 2),
                        'defaultMarkup' => 'yes',
                        'beforePrice' => $price,
                        'markupValue' => $defaultMarkup['b2c_markup'],
                        'markupType' => $defaultMarkup['b2c_markup_type'],
                        'markupFee' => $defaultMarkupAmount,
                        'service_calculation_method' => $defaultMarkup['service_calculation_method'] ?? 'from_total',
                        'ancillary_service_markup_type' => $ancillaryServiceMarkupType ?? '', 
                        'ancillary_service_markup' => $highestAncillaryAmount ?? 0, 
                    ];
                    break;
                }
            }
        }

        return $updatedPriceDetails;
    }
}
