<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Stichoza\GoogleTranslate\GoogleTranslate;

class TranslateService
{
    /**
     * Translate text using Google Translate API
     */
    public static function translateTextUsingScript($text, $source = 'en', $target = 'ar')
    {
        $response = Http::asForm()->post(
            'https://script.google.com/macros/s/AKfycbyE659nxkNXR83fdVBhG06mlr49Y5RJYISR13rDs7pCqGo4LdO5afRObZhDeyi69w3IsA/exec',
            [
                'text' => $text,
                'source_lang' => $source,
                'target_lang' => $target,
            ]
        );

        if ($response->successful()) {
            $response = json_decode($response->body(), true);
            if ($response['status'] == 'success' && isset($response['translatedText'])) {
                return $response['translatedText'];
            }
            return $text;
        }
        return $text;
    }

    /**
     * Translate text using Stichoza Google Translate package
     */
    public static function translateText($text, $source = 'en', $target = 'ar')
    {
        try {
            $tr = new GoogleTranslate();
            $tr->setSource($source);
            $tr->setTarget($target);
            return $tr->translate($text);
        } catch (\Throwable $e) {
            return $text;
        }
    }
}
