<?php

namespace App\Services;

use Throwable;
use Illuminate\Support\Facades\Cache;

class RedisCache
{
    public static function cache($key, $expire = 300, $callback)
    {
        try {
            return Cache::remember($key, $expire, function () use ($callback) {
                $value = $callback();
                return $value ?? null;
            });
        } catch (Throwable $e) {
            self::forgetCache($key);
            report($e);
            return null;
        }
    }

    public static function cacheForever($key, $callback)
    {
        try {
            return Cache::rememberForever($key, function () use ($callback) {
                $value = $callback();
                return $value ?? null;
            });
        } catch (Throwable $e) {
            self::forgetCache($key);
            report($e);
            return null;
        }
    }

    public static function forgetCache($key)
    {
        Cache::forget($key);
    }
}
