<?php
namespace App\Services;

use App\Models\HotelFacility;
use Illuminate\Support\Facades\Cache;

class HotelFacilityService
{
    /**
     * Get facilities for hotels with optional caching
     */
    public function getFacilities(array $hotelIds, bool $useCache = true)    {
        if (!$useCache) {
            return HotelFacility::getByHotelIds($hotelIds);
        }
		sort($hotelIds);
		$hotelIdsStr = implode(',', $hotelIds);

        $cacheKey = 'hotel_facilities_' . md5($hotelIdsStr);
        
        return Cache::remember($cacheKey, 3600, function () use ($hotelIds) {
            return HotelFacility::getByHotelIds($hotelIds);
        });
    }
}