<?php

namespace App\Observers;

use App\Models\User;
use App\Models\UserLog;
use Illuminate\Support\Facades\Auth;

class UserObserver
{
    /**
     * Handle the User "created" event.
     */
    public function created(User $user): void
    {
        try {
            UserLog::create([
                'user_id'   => $user->id,
                'log_name'    => 'User Created',
                'log_description' => 'User created successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the User "updated" event.
     */
    public function updated(User $user): void
    {
        $logDescription = collect($user->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            UserLog::create([
                'user_id'   => $user->id,
                'log_name'    => 'User Updated',
                'log_description' => $logDescription,
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the User "deleted" event.
     */
    public function deleted(User $user): void
    {
         try {
            UserLog::create([
                'user_id'   => $user->id,
                'log_name'    => 'User Deleted',
                'log_description' => 'User Deleted Successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the User "restored" event.
     */
    public function restored(User $user): void
    {
        //
    }

    /**
     * Handle the User "force deleted" event.
     */
    public function forceDeleted(User $user): void
    {
        //
    }
}
