<?php

namespace App\Observers;

use App\Models\EditFlightDetail;
use App\Models\EditFlightBookingLog;
use Illuminate\Support\Facades\Auth;

class EditFlightBookingObserver
{
    /**
     * Handle the EditFlightBooking "created" event.
     */
    public function created(EditFlightDetail $editFlightBooking): void
    {
        // EditFlightBookingLog::create([
        //     'log_name' => 'create',
        //     'log_description' => 'Edit Flight Booking created',
        //     'created_by' => Auth::id()
        // ]);
    }

    /**
     * Handle the EditFlightBooking "updated" event.
     */
    public function updated(EditFlightDetail $editFlightBooking): void
    {
        $logDescription = collect($editFlightBooking->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            EditFlightBookingLog::create([
                'booking_id' => $editFlightBooking->booking_id,
                'log_name' => 'Updated',
                'log_description' => json_encode($logDescription),
                'created_by' => Auth::id() ?? 0
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the EditFlightBooking "deleted" event.
     */
    public function deleted(EditFlightDetail $editFlightBooking): void
    {
        //
    }

    /**
     * Handle the EditFlightBooking "restored" event.
     */
    public function restored(EditFlightDetail $editFlightBooking): void
    {
        //
    }

    /**
     * Handle the EditFlightBooking "force deleted" event.
     */
    public function forceDeleted(EditFlightDetail $editFlightBooking): void
    {
        //
    }
}
