<?php

namespace App\Observers;

use App\Models\CustomerLoginToken;
use App\Models\LoginAsCustomerLog;
use Illuminate\Support\Facades\Auth;
use Elastic\Elasticsearch\Endpoints\Cat;

class CustomerLoginTokenObserver
{
    /**
     * Handle the CustomerLoginToken "created" event.
     */
    public function created(CustomerLoginToken $customerLoginToken): void
    {
        try {
            LoginAsCustomerLog::create([
                'customer_id' => $customerLoginToken->customer_id,
                'log_name' => 'Logged In By ' . optional(auth()->user())->name,
                'created_by' => Auth::id()
            ]);
        } catch (\Exception $e) {
            logger()->error('LoginAsCustomerLog insert failed: ' . $e->getMessage(), [
                'customer_id' => $customerLoginToken->customer_id,
                'created_by' => Auth::id(),
            ]);
        }
    }

    /**
     * Handle the CustomerLoginToken "updated" event.
     */
    public function updated(CustomerLoginToken $customerLoginToken): void
    {
        //
    }

    /**
     * Handle the CustomerLoginToken "deleted" event.
     */
    public function deleted(CustomerLoginToken $customerLoginToken): void
    {
        //
    }

    /**
     * Handle the CustomerLoginToken "restored" event.
     */
    public function restored(CustomerLoginToken $customerLoginToken): void
    {
        //
    }

    /**
     * Handle the CustomerLoginToken "force deleted" event.
     */
    public function forceDeleted(CustomerLoginToken $customerLoginToken): void
    {
        //
    }
}
