<?php

namespace App\Observers;

use App\Models\Coupon;
use App\Models\CouponLog;
use Illuminate\Support\Facades\Auth;

class CouponObserver
{
    /**
     * Handle the Coupon "created" event.
     */
    public function created(Coupon $coupon): void
    {
        try {
            CouponLog::create([
                'log_name'    => 'created',
                'coupon_id'   => $coupon->id,
                'updated_field' => 'coupon created',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Coupon "updated" event.
     */
    public function updated(Coupon $coupon): void
    {
        $logDescription = collect($coupon->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            CouponLog::create([
                'log_name'    => 'coupon updated',
                'coupon_id'   => $coupon->id,
                'updated_field' => $logDescription,
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Coupon "deleted" event.
     */
    public function deleted(Coupon $coupon): void
    {
        try {
            CouponLog::create([
                'log_name'    => 'Coupon Deleted',
                'coupon_id'   => $coupon->id,
                'updated_field' => 'deleted',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Coupon "restored" event.
     */
    public function restored(Coupon $coupon): void
    {
        //
    }

    /**
     * Handle the Coupon "force deleted" event.
     */
    public function forceDeleted(Coupon $coupon): void
    {
        //
    }
}
