<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Carbon;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class TourCode extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'tour_codes';

    protected $guarded = [];

    protected static $logName = 'tour_codes';
    protected $fillable = ['tour_code', 'from_airports', 'to_airports', 'from_date', 'to_date', 'status'];

    /**
     * ger list or single or all records to display
     */
    public static function getTourCodes($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = TourCode::query();
                $query->select('tour_codes.*');
                $query->where('tour_codes.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = TourCode::query();
                $query->select('tour_codes.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('tour_codes.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Tour Code list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createTourCode($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $tourCodeArrayData = array(
            'tour_code' => $requestData['tour_code'],
            'from_airports' => $requestData['from_airports'],
            'to_airports' => $requestData['to_airports'],
            'from_date' => $requestData['from_date'],
            'to_date' => $requestData['to_date'],
            'status' => $requestData['status'],
        );
        try {
            DB::beginTransaction();
            $tourCodeData = TourCode::create($tourCodeArrayData);
            DB::commit();
            if ($tourCodeData) {
                $return['status'] = 1;
                $return['message'] = 'Tour Code "'. $requestData['tour_code'] . '" have created successfully';
                $return['data'] = $tourCodeData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save TourCodes : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateTourCode($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            @$tourCodeTypeDetails = array(
                'id' => $requestData['id'],
                'tour_code' => $requestData['tour_code'],
                'from_airports' => $requestData['from_airports'],
                'to_airports' => $requestData['to_airports'],
                'from_date' => $requestData['from_date'],
                'to_date' => $requestData['to_date'],
                'status' => $requestData['status'],
            );
            try {

                DB::beginTransaction();
                $matchTourCodeType = ['id' => $tourCodeTypeDetails['id']];
                $TourCodeType = TourCode::updateOrCreate($matchTourCodeType, $tourCodeTypeDetails);
                DB::commit();
                if ($TourCodeType) {
                    $return['status'] = 1;
                    $return['message'] = 'Tour Code "'. $requestData['tour_code'] . '" have updated successfully';
                    $return['data'] = $TourCodeType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update TourCodes : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteTourCode($tourCodeId)
    {

        $tourCodeDetails = TourCode::where('id', $tourCodeId)->first()->toArray();
        if ($tourCodeDetails) {
            TourCode::where('id', $tourCodeId)->delete();

            $return['status'] = 1;
            $return['message'] = 'Tour Code "' . $tourCodeDetails['tour_code'] . '" have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
