<?php

namespace App\Models;

use DB;
use DateTime;
use App\Traits\Uuids;
use Illuminate\Support\Carbon;
use App\Traits\ClearsHomePageCache;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SeoTrendingHotel extends Model
{
    use HasFactory, LogsActivity, Uuids, ClearsHomePageCache,HasActivityLogging;

    protected $table = 'seo_trending_hotels';

    protected $guarded = [];

    protected static $logName = 'trending_hotels';
    protected $fillable = [

    'city_en', 
    'city_ar', 
    'status', 
    'content',
    'arabic_content',
    'title',
    'arabic_title',
    'sub_title',
    'arabic_sub_title',
    'banner_title',
    'arabic_banner_title',
    'upload_banner',
    'banner',
    'banner_sub_title',
    'arabic_banner_sub_title',


];

    /**
     * ger list or single or all records to display
     */
    public static function getSeoTrendingHotels($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = SeoTrendingHotel::query();
                $query->select('seo_trending_hotels.*');
                $query->where('seo_trending_hotels.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = SeoTrendingHotel::query();
                $query->select('seo_trending_hotels.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('seo_trending_hotels.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'SEO Trending Hotel list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createSeoTrendingHotel($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $seoTrendingHotelArrayData = array(
            'city_ar' => $requestData['city_ar'],
            'city_en' => $requestData['city_en'],
            'status' => $requestData['status'],
            'content' => $requestData['content'],
            'arabic_content' => $requestData['arabic_content'],
            
            'title' => $requestData['title'],
            'arabic_title' => $requestData['arabic_title'],
            'sub_title' => $requestData['sub_title'],
            'arabic_sub_title' => $requestData['arabic_sub_title'],
            'banner_title' => $requestData['banner_title'],
            'arabic_banner_title' => $requestData['arabic_banner_title'],
            'banner_sub_title' => $requestData['banner_sub_title'],
            'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
        );


        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $seoTrendingHotelTypeDetails['banner'] = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        } 



        try {
            DB::beginTransaction();
            $seoTrendingHotelData = SeoTrendingHotel::create($seoTrendingHotelArrayData);
            DB::commit();
            if ($seoTrendingHotelData) {
                $return['status'] = 1;
                $return['message'] = 'SEO Trending Hotel have created successfully';
                $return['data'] = $seoTrendingHotelData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save TrendingHotels : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateSeoTrendingHotel($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            $seoTrendingHotelTypeDetails = array(
                'id' => $requestData['id'],
                'city_ar' => $requestData['city_ar'],
                'city_en' => $requestData['city_en'],
                'status' => $requestData['status'],
                'content' => $requestData['content'],
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'],
                'arabic_title' => $requestData['arabic_title'],
                'sub_title' => $requestData['sub_title'],
                'arabic_sub_title' => $requestData['arabic_sub_title'],
                'banner_title' => $requestData['banner_title'],
                'arabic_banner_title' => $requestData['arabic_banner_title'],
                'banner_sub_title' => $requestData['banner_sub_title'],
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
            );


        if (isset($requestData['upload_banner']) && $requestData['upload_banner'] != '') {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $seoTrendingHotelTypeDetails['banner'] = $url;

                 // dd($seoTrendingHotelTypeDetails);

            } catch (\Exception $e) {
                $return['message'] = 'Error during save Home Banner : ' . $e->getMessage();
            }
        }
       




            try {

                DB::beginTransaction();
                $matchTrendingHotelType = ['id' => $seoTrendingHotelTypeDetails['id']];
                $TrendingHotelType = SeoTrendingHotel::updateOrCreate($matchTrendingHotelType, $seoTrendingHotelTypeDetails);
                DB::commit();
                if ($TrendingHotelType) {
                    $return['status'] = 1;
                    $return['message'] = 'SEO Trending Hotel have updated successfully';
                    $return['data'] = $TrendingHotelType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update TrendingHotels : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteSeoTrendingHotel($trendingHotelId)
    {

        $trendingHotelDetails = SeoTrendingHotel::where('id', $trendingHotelId)->first()->toArray();
        if ($trendingHotelDetails) {
            TrendingHotel::where('id', $trendingHotelId)->delete();

            $return['status'] = 1;
            $return['message'] = 'SEO Trending Hotel have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
