<?php

namespace App\Models;

use DB;
use DateTime;
use App\Traits\Uuids;
use Illuminate\Support\Carbon;
use App\Traits\ClearsHomePageCache;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class SeoTrendingFlight extends Model
{
    use HasFactory, LogsActivity, Uuids, ClearsHomePageCache,HasActivityLogging;

    protected $table = 'seo_trending_flights';

    protected $guarded = [];

    protected static $logName = 'seo_trending_flights';
    protected $fillable = [
        'from_airport_id',
        'from_airport_name',
        'from_airport',
        'from_airport_city_en',
        'from_airport_city_ar',
        'to_airport_id',
        'to_airport_name',
        'to_airport',
        'to_airport_city_en',
        'to_airport_city_ar',
        'status',
        'content',
        'arabic_content',
        'title',
        'arabic_title',
        'sub_title',
        'arabic_sub_title',
        'banner_title',
        'arabic_banner_title',
        'upload_banner',
        'banner',
        'banner_sub_title',
        'arabic_banner_sub_title',
    ];

    /**
     * ger list or single or all records to display
     */
    public static function getSeoTrendingFlights($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = SeoTrendingFlight::query();
                $query->select('seo_trending_flights.*');
                $query->where('seo_trending_flights.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = SeoTrendingFlight::query();
                $query->select('seo_trending_flights.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('seo_trending_flights.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'SeoTrending Flight list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createSeoTrendingFlight($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $seoTrendingFlightArrayData = array(
            'from_airport_id' => $requestData['from_airport_id'],
            'from_airport_name' => $requestData['from_airport_name'],
            'from_airport' => $requestData['from_airport'],
            'from_airport_city_en' => $requestData['from_airport_city_en'],
            'from_airport_city_ar' => $requestData['from_airport_city_ar'],
            'to_airport_id' => $requestData['to_airport_id'],
            'to_airport_name' => $requestData['to_airport_name'],
            'to_airport' => $requestData['to_airport'],
            'to_airport_city_en' => $requestData['to_airport_city_en'],
            'to_airport_city_ar' => $requestData['to_airport_city_ar'],
            'status' => $requestData['status'],
            'content' => $requestData['content'],
            'arabic_content' => $requestData['arabic_content'],
            
            'title' => $requestData['title'],
            'arabic_title' => $requestData['arabic_title'],
            'sub_title' => $requestData['sub_title'],
            'arabic_sub_title' => $requestData['arabic_sub_title'],
            'banner_title' => $requestData['banner_title'],
            'arabic_banner_title' => $requestData['arabic_banner_title'],
            'banner_sub_title' => $requestData['banner_sub_title'],
            'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
        );


            if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $seoTrendingFlightArrayData['banner'] = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        } 
         



        try {
            DB::beginTransaction();
            $seoTrendingFlightData = SeoTrendingFlight::create($seoTrendingFlightArrayData);
            DB::commit();
            if ($seoTrendingFlightData) {
                $return['status'] = 1;
                $return['message'] = 'SEO Trending Flight have created successfully';
                $return['data'] = $seoTrendingFlightData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save SeoTrendingFlights : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateSeoTrendingFlight($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            $seoTrendingFlightTypeDetails = array(
                'id' => $requestData['id'],
                'from_airport_id' => $requestData['from_airport_id'],
                'from_airport_name' => $requestData['from_airport_name'],
                'from_airport' => $requestData['from_airport'],
                'from_airport_city_en' => $requestData['from_airport_city_en'],
                'from_airport_city_ar' => $requestData['from_airport_city_ar'],
                'to_airport_id' => $requestData['to_airport_id'],
                'to_airport_name' => $requestData['to_airport_name'],
                'to_airport' => $requestData['to_airport'],
                'to_airport_city_en' => $requestData['to_airport_city_en'],
                'to_airport_city_ar' => $requestData['to_airport_city_ar'],
                'status' => $requestData['status'],
                'content' => $requestData['content'],
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'],
                'arabic_title' => $requestData['arabic_title'],
                'sub_title' => $requestData['sub_title'],
                'arabic_sub_title' => $requestData['arabic_sub_title'],
                'banner_title' => $requestData['banner_title'],
                'arabic_banner_title' => $requestData['arabic_banner_title'],
                'banner_sub_title' => $requestData['banner_sub_title'],
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],

            );


           


        if (isset($requestData['upload_banner']) && $requestData['upload_banner'] != '') {



            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $seoTrendingFlightTypeDetails['banner'] = $url;

                 // dd($seoTrendingFlightTypeDetails);

            } catch (\Exception $e) {
                $return['message'] = 'Error during save Home Banner : ' . $e->getMessage();
            }
        }
       





            try {

                DB::beginTransaction();
                $matchSeoTrendingFlightType = ['id' => $seoTrendingFlightTypeDetails['id']];
                $SeoTrendingFlightType = SeoTrendingFlight::updateOrCreate($matchSeoTrendingFlightType, $seoTrendingFlightTypeDetails);
                DB::commit();
                if ($SeoTrendingFlightType) {
                    $return['status'] = 1;
                    $return['message'] = 'SEO Trending Flight have updated successfully';
                    $return['data'] = $SeoTrendingFlightType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update SeoTrendingFlights : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteSeoTrendingFlight($seoTrendingFlightId)
    {

        $seoTrendingFlightDetails = SeoTrendingFlight::where('id', $seoTrendingFlightId)->first()->toArray();
        if ($seoTrendingFlightDetails) {
            SeoTrendingFlight::where('id', $seoTrendingFlightId)->delete();

            $return['status'] = 1;
            $return['message'] = 'SEO Trending Flight have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
