<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Carbon;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class NegFare extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'neg_fares';

    protected $guarded = [];

    protected static $logName = 'neg_fares';
    protected $fillable = ['title', 'from_airports', 'to_airports', 'from_date', 'to_date', 'status'];

    /**
     * ger list or single or all records to display
     */
    public static function getNegFares($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = NegFare::query();
                $query->select('neg_fares.*');
                $query->where('neg_fares.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = NegFare::query();
                $query->select('neg_fares.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('neg_fares.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Neg Fare list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createNegFare($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $negFareArrayData = array(
            'title' => $requestData['title'],
            'from_airports' => $requestData['from_airports'],
            'to_airports' => $requestData['to_airports'],
            'from_date' => $requestData['from_date'],
            'to_date' => $requestData['to_date'],
            'status' => $requestData['status'],
        );
        try {
            DB::beginTransaction();
            $negFareData = NegFare::create($negFareArrayData);
            DB::commit();
            if ($negFareData) {
                $return['status'] = 1;
                $return['message'] = 'Neg Fare "'. $requestData['title'] . '" have created successfully';
                $return['data'] = $negFareData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save NegFares : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateNegFare($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            @$negFareTypeDetails = array(
                'id' => $requestData['id'],
                'title' => $requestData['title'],
                'from_airports' => $requestData['from_airports'],
                'to_airports' => $requestData['to_airports'],
                'from_date' => $requestData['from_date'],
                'to_date' => $requestData['to_date'],
                'status' => $requestData['status'],
            );
            try {

                DB::beginTransaction();
                $matchNegFareType = ['id' => $negFareTypeDetails['id']];
                $NegFareType = NegFare::updateOrCreate($matchNegFareType, $negFareTypeDetails);
                DB::commit();
                if ($NegFareType) {
                    $return['status'] = 1;
                    $return['message'] = 'Neg Fare "'. $requestData['title'] . '" have updated successfully';
                    $return['data'] = $NegFareType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update Featured NegFares : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteNegFare($negFareId)
    {

        $negFareDetails = NegFare::where('id', $negFareId)->first()->toArray();
        if ($negFareDetails) {
            NegFare::where('id', $negFareId)->delete();

            $return['status'] = 1;
            $return['message'] = 'Neg Fare "' . $negFareDetails['title'] . '" have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
