<?php

namespace App\Models;

use App\Enums\Locale;
use App\Traits\Uuids;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MailCampaign extends Model
{
    use HasFactory,Uuids;
    protected $table = 'mail_campaigns';
    protected $guarded = [];
    public function mailCodeName()
    {
        return $this->hasMany('App\Models\MailCampaignI18ns', 'mail_id', 'id');
    }
    public function mailCodeNameSingle()
    {
        return $this->hasOne('App\Models\MailCampaignI18ns', 'mail_id', 'id');
    }

    /**
     * get list or single or all records to display
     */
    public static function getMailCampaignData($option = array())
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $data = array(
            'id' => '',
            'order_by' => 'id',
            'sorting' => 'desc',
            'where' => array(),
            'orWhere' => array()
        );
        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = MailCampaign::query();
                $query->with('mailCodeName');
                $query->select(
                    "mail_campaigns.*",

                );
                $query->where('mail_campaigns.id', $config['id']);

                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = MailCampaign::query();
                $query->with('mailCodeName');
                $query->whereHas('mailCodeName', function ($q) use ($config) {
                    if (!empty($config['whereHas'])) {
                        foreach ($config['whereHas'] as $where) {
                            $q->where($where[0], $where[1], $where[2]);
                        }
                    }
                });
                $query->select(
                    "mail_campaigns.*",

                );
                if ($config['order_by'] == 'name') {
                    $query->join('mail_campaign_i18ns', 'mail_campaigns.id', '=', 'mail_campaigns_i18ns.mail_id')
                        ->where('mail_campaign_i18ns.language_code', Locale::English->value)
                        ->orderBy('mail_campaign_i18ns.name', $config['sorting']);
                }
                $query->orderBy($config['order_by'], $config['sorting']);
                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where($where[0], $where[1], $where[2]);
                    }
                }
                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                $result = $query->paginate($config['per_page']);
                $result->setPath('?per_page=' . $config['per_page']);
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        }

        if (!empty($result)) {
            $return['status'] = 1;
            $return['message'] = 'Mail Campaign list successfully';
            $return['data'] = $result;
            return $return;
        } else {
            return $return;
        }
    }



    public static function createMailCampaign($requestData)
{
    $return = array(
        'status' => 0,
        'message' => 'Something went wrong',
        'data' => []
    );

    try {
        $mailCampaignDetails = array(
            'code' => $requestData['code'],
            // // 'from_email' => $requestData['from_email'],
            // // 'to_email' => $requestData['to_email'],
            // 'cc' => $requestData['cc']??'',
            // 'bcc' => $requestData['bcc']??'',
        );

        DB::beginTransaction();

        $mailCampaignData = MailCampaign::create($mailCampaignDetails);

        if ($mailCampaignData) {
            $pagemsg = [];

            foreach ($requestData['mail'] as $mail) {
                $nameData = array(
                    'mail_id' => $mailCampaignData->id,
                    'name' => $mail['name']??'',
                    'content' => $mail['content'],
                    'subject' => $mail['subject'],
                    'language_code' => $mail['language_code'],
                );

                MailCampaignI18ns::create($nameData);
                $pagemsg[] = $mail['name']??'';
            }

            DB::commit();

            $return['status'] = 1;
            $return['message'] = 'Mail [' . implode(', ', $pagemsg) . '] created successfully.';
            $return['data'] = $mailCampaignData;
        }
    } catch (\Exception $e) {
        DB::rollBack();
        $return['message'] = 'Error while creating mail campaign: ' . $e->getMessage();
    }

    return $return;
}


    /**
     * update record in database
     */
    public static function updateMailCampaign($requestData)
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            @$mailCampaignDetails = array(
                'id' => $requestData['mail_campaign_id'],
                'code' => $requestData['code'],
                // 'from_email' => $requestData['from_email'],
                // // 'to_email' => $requestData['to_email'],
                // 'cc' => $requestData['cc'],
                // 'bcc' => $requestData['bcc'],
            );
            try {
                DB::beginTransaction();

                $matchMailCampaignType = ['id' => $mailCampaignDetails['id']];
                $mailCampaignData = MailCampaign::updateOrCreate($matchMailCampaignType, $mailCampaignDetails);

                if ($mailCampaignData) {

                    $mailNames['mail'] = $requestData['mail'];
                    foreach ($mailNames['mail'] as $key => $name) {
                        $nameData = array(
                            'mail_id' => $mailCampaignData->id,
                            'name' => $name['name'],
                            'content' => $name['content'],
                            'subject' => $name['subject'],
                            'language_code' => $name['language_code'],
                        );
                        $matchpageData = ['id' => $name['mailCampaign_i18ns_id']];
                        MailCampaignI18ns::updateOrCreate($matchpageData, $nameData);
                        $pagemsg[] = $name['name'];
                    }
                }
                DB::commit();
                if ($mailCampaignData) {
                    $return['status'] = 1;
                    $return['message'] = 'Mail [' . implode(', ', $pagemsg) . '] updated Successfully.';
                    $return['data'] = $mailCampaignData;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    /**
     * indert data in database by seeder file
     */
    public static function createSeederMailCampaigns($requestData)
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            $mailData = array(
                'code'  => $requestData['code'],
                'from_email'  => $requestData['from_email'],
                'to_email'  => $requestData['to_email'],
                'cc'  => $requestData['cc'],
                'bcc'  => $requestData['bcc']

            );
            // save to table
            try {
                DB::beginTransaction();
                $mailDetails = MailCampaign::create($mailData);


                if ($mailDetails) {

                    $pagesData = $requestData['mail_data'];

                    foreach ($pagesData as $key => $mail) {

                        $nameData = array(
                            'mail_id' => $mailDetails->id,
                            'name' => $mail['name'],
                            'content' => $mail['content'],
                            'subject' => $mail['subject'],
                            'language_code' => $mail['language_code']
                        );
                        MailCampaignI18ns::create($nameData);
                        $mailmsg[] = $mail['name'];
                    }

                    $return['status'] = 1;
                    $return['message'] = 'Sms [' . implode(', ', $mailmsg) . '] saved successfully.';
                    $return['data'] = $mail;
                }
                DB::commit();
            } catch (\Exception $e) {
                $return['message'] = 'Error during save record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }
}
