<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Carbon;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class LoyaltyPointsMap extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'loyalty_points_map';

    protected $guarded = [];

    protected static $logName = 'loyalty_points_map';

    protected $fillable = ['service', 'calculation_type', 'value', 'city', 'service_provider', 'from_place', 'to_place', 'start_date', 'end_date', 'is_common'];

    /**
     * ger list or single or all records to display
     */
    public static function getLoyaltyPointsMapList($where = [])
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $query = LoyaltyPointsMap::query();
        if (count($where) > 0) {
            foreach($where as $key => $value) {
                $query->where($value['field'], $value['condition'], $value['value']);
            }
        }
        $result = $query->get();
        if ($result) {
            $return['status'] = 1;
            $return['message'] = 'Loyalty map list successfully';
            $return['data'] = $result->toArray();
            return $return;
        }

        return $return;
    }

    public static function searchLoyaltyPointsMap($searchCriteria) {
        $details = [];
        $query = LoyaltyPointsMap::query();
        $query->select('calculation_type', 'value');
        if (count($searchCriteria) > 0) {
            foreach($searchCriteria as $key => $value) {
                $query->where($value['field'], $value['condition'], $value['value']);
            }
        }

        $result = $query->first();
        if ($result) {
            $details = $result->toArray();
        }
        return $details;
    }

    public static function createLoyaltyPointsMap($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        try {
            DB::beginTransaction();
            $result = LoyaltyPointsMap::create($requestData);
            DB::commit();
            if ($result) {
                $return['status'] = 1;
                $return['message'] = 'Loyalty map have created successfully';
                $return['data'] = $result;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save Loyalty Point To Riyal : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateLoyaltyPointsMap($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            DB::beginTransaction();
            $where = ['id' => $requestData['id']];
            $result = LoyaltyPointsMap::updateOrCreate($where, $requestData);
            DB::commit();
            if ($result) {
                $return['status'] = 1;
                $return['message'] = 'Loyalty map have updated successfully';
                $return['data'] = $result;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteLoyaltyPointsMap($id)
    {

        $loyaltyPointToRiyal = LoyaltyPointsMap::where('id', $id)->first()->toArray();
        if ($loyaltyPointToRiyal) {
            LoyaltyPointsMap::where('id', $id)->delete();

            $return['status'] = 1;
            $return['message'] = 'Loyalty map have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete Loyalty point to riyal. Please try again.';
        }

        return $return;
    }
}
