<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Carbon;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class LoyaltyPointToRiyal extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'loyalty_points_to_riyal';

    protected $guarded = [];

    protected static $logName = 'loyalty_points_to_riyal';

    protected $fillable = ['service', 'points', 'riyal'];

    /**
     * ger list or single or all records to display
     */
    public static function getLoyaltyPointToRiyalList($where = [])
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $query = LoyaltyPointToRiyal::query();
        if (count($where) > 0) {
            foreach($where as $key => $value) {
                $query->where($value['field'], $value['condition'], $value['value']);
            }
        }
        $result = $query->get();
        if ($result) {
            $return['status'] = 1;
            $return['message'] = 'Loyalty Point list successfully';
            $return['data'] = $result->toArray();
            return $return;
        }

        return $return;
    }

    public static function getLoyaltyPointToRiyal($service) {
        $points = 0;
        $result = LoyaltyPointToRiyal::where('service', $service)->first();
        if ($result) {
            $points = $result->points;
        }
        return $points;
    }

    public static function getRedeemPointToRiyal($service) {
        $points = 0;
        $result = LoyaltyPointToRiyal::where('service', $service)->first();
        if ($result) {
            $points = $result->redeem_points;
        }
        return $points;
    }

    public static function createLoyaltyPointToRiyal($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        try {
            DB::beginTransaction();
            $result = LoyaltyPointToRiyal::create($requestData);
            DB::commit();
            if ($result) {
                $return['status'] = 1;
                $return['message'] = 'Loyalty point to riyal data have created successfully';
                $return['data'] = $result;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save Loyalty Point To Riyal : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateLoyaltyPointToRiyal($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            DB::beginTransaction();
            $where = ['id' => $requestData['id']];
            $result = LoyaltyPointToRiyal::updateOrCreate($where, $requestData);
            DB::commit();
            if ($result) {
                $return['status'] = 1;
                $return['message'] = 'Loyalty point to riyal data have updated successfully';
                $return['data'] = $result;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteLoyaltyPointToRiyal($id)
    {

        $loyaltyPointToRiyal = LoyaltyPointToRiyal::where('id', $id)->first()->toArray();
        if ($loyaltyPointToRiyal) {
            LoyaltyPointToRiyal::where('id', $id)->delete();

            $return['status'] = 1;
            $return['message'] = 'Loyalty point to riyal data have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete Loyalty point to riyal. Please try again.';
        }

        return $return;
    }
}
