<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HotelSpecialRequest extends Model
{
    use Uuids,SoftDeletes;
    protected $table = 'hotel_special_requests';
    protected $fillable = [
        'special_request_name',
        'special_request_name_ar',
        'status',
        'created_by'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public static function getSpecialRequestList(){
       return self::with('user')->latest()->get();
    }
}
