<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HotelDescriptionEn extends Model
{
    protected $connection = 'mysql_static_content';
    protected $table = 'hotel_descriptions_en';
    public $timestamps = false;
    
    protected $fillable = [
        'hotel_id',
        'title',
        'language', 
        'line',
        'paragraph'
    ];

    /**
     * Get English descriptions for multiple hotels
     */
    public static function getByHotelIds(array $hotelIds)
    {
        if (empty($hotelIds)) {
            return [];
        }

        return static::whereIn('hotel_id', $hotelIds)
            ->select(['hotel_id', 'title', 'language', 'line', 'paragraph'])
            ->orderBy('hotel_id')
            ->orderBy('line')
            ->get()
            ->groupBy('hotel_id')
            ->toArray();
    }
}