<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Carbon;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class GimmonixSearchSession extends Model
{
    use HasFactory, Uuids;

    protected $table = 'gimmonix_sessions';

    protected $guarded = [];

    protected static $logName = 'gimmonix_sessions';
    protected $fillable = ['log_id', 'session_id', 'search_id', 'expires_at'];

    /**
     * ger list or single or all records to display
     */
    public static function getGimmonixSearchSessions($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = GimmonixSearchSession::query();
                $query->select('gimmonix_search_sessions.*');
                $query->where('gimmonix_search_sessions.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = GimmonixSearchSession::query();
                $query->select('gimmonix_search_sessions.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('gimmonix_search_sessions.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Gimmonix Search Session list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createGimmonixSearchSession($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $gimmonixSearchSessionArrayData = array(
            'log_id' => $requestData['log_id'],
            'session_id' => $requestData['session_id'],
            'search_id' => $requestData['search_id'],
        );
        try {
            DB::beginTransaction();
            $gimmonixSearchSessionData = GimmonixSearchSession::create($gimmonixSearchSessionArrayData);
            DB::commit();
            if ($gimmonixSearchSessionData) {
                $return['status'] = 1;
                $return['message'] = 'Gimmonix Search Session have created successfully';
                $return['data'] = $gimmonixSearchSessionData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save GimmonixSearchSessions : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateGimmonixSearchSession($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            @$gimmonixSearchSessionTypeDetails = array(
                'id' => $requestData['id'],
                'log_id' => $requestData['log_id'],
                'session_id' => $requestData['session_id'],
                'search_id' => $requestData['search_id'],
            );
            try {

                DB::beginTransaction();
                $matchGimmonixSearchSessionType = ['id' => $gimmonixSearchSessionTypeDetails['id']];
                $GimmonixSearchSessionType = GimmonixSearchSession::updateOrCreate($matchGimmonixSearchSessionType, $gimmonixSearchSessionTypeDetails);
                DB::commit();
                if ($GimmonixSearchSessionType) {
                    $return['status'] = 1;
                    $return['message'] = 'Gimmonix Search Session have updated successfully';
                    $return['data'] = $GimmonixSearchSessionType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update GimmonixSearchSessions : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteGimmonixSearchSession($gimmonixSearchSessionId)
    {

        $gimmonixSearchSessionDetails = GimmonixSearchSession::where('id', $gimmonixSearchSessionId)->first()->toArray();
        if ($gimmonixSearchSessionDetails) {
            GimmonixSearchSession::where('id', $gimmonixSearchSessionId)->delete();

            $return['status'] = 1;
            $return['message'] = 'Gimmonix Search Session have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
