<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LoyaltyPointSetting;
use Illuminate\Http\Request;

class GeneralSettingController extends Controller
{
    public function index()
    {
        $loyalty_point_settings = LoyaltyPointSetting::first();
        return view('admin.general-setting.index' , ['loyalty_settings' => $loyalty_point_settings]);
    }


    public function store(Request  $request)
    {
        $requestData = $request->all();
        if($requestData['save_type'] == 'loyalty-settings')
        {
            $loyaltySettings = LoyaltyPointSetting::updateOrCreate(
                [ 'id' => $requestData['id'] ],
            [
                'expiry_year' => $requestData['expiry_year'],
                'expiry_month' => $requestData['expiry_month'],
                'expiry_day' => $requestData['expiry_day'],
            ]
            );

            if($loyaltySettings)
            {
                return response()->json(['status' => 'success', 'message' => 'Loyalty settings saved successfully']);
            }

        }
    }
}
