<?php

namespace App\Models;


use DB;
use DateTime;
use App\Traits\Uuids;
use Illuminate\Support\Carbon;
use App\Traits\ClearsHomePageCache;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Spatie\Activitylog\Traits\LogsActivity;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FeatureHotel extends Model
{
    use HasFactory, LogsActivity, Uuids,ClearsHomePageCache,HasActivityLogging;
    protected $table = 'featured_hotels';

    protected $guarded = [];

    protected static $logName = 'featured_hotels';
    protected $fillable = ['hotel_name','hotel_name_ar','hotel_link', 'location', 'location_ar', 'hotel_image', 'price', 'rating', 'hot_deal', 'status'];


    /**
     * ger list or single or all records to display
     */
    public static function getFeatureHotels($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);

        $result = [];
        if ($config['id'] != '') {
            try {
                $query = FeatureHotel::query();
                $query->select('featured_hotels.*');
                $query->where('featured_hotels.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = FeatureHotel::query();
                $query->select('featured_hotels.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('featured_hotels.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif(isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }

        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Featured Hotels list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createFeatureHotel($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        $featureHotelArrayData = array(
            'hotel_name' => $requestData['hotel_name'],
            'hotel_name_ar' => $requestData['hotel_name_ar'],
            'hotel_link' => $requestData['hotel_link'],
            'location' => $requestData['location'],
            'location_ar' => $requestData['location_ar'],
            'hotel_image' => $requestData['hotel_image'],
            'price' => $requestData['price'],
            'rating' => $requestData['rating'],
            'hot_deal' => $requestData['hot_deal'],
            'status' => $requestData['status'],
        );
        if (strpos(request()->path(), 'api') === false && isset($requestData['hotel_image'])) {
            //upload image
            try {
                $destinationPath = storage_path() . '/app/public/feature-hotel/';
                if (!is_dir($destinationPath)) {
                    mkdir($destinationPath, 0777);
                }

                $file = $requestData['hotel_image'];
                $image_resize = Image::make($requestData['hotel_image']);
                $image_resize->resize(300, 300);
                $fileName =  uniqid() . time() . '.' . $requestData['hotel_image']->extension();
                $image_resize->save($destinationPath . $fileName);
                $url = URL::to('/storage/') . '/feature-hotel/' . $fileName;
                $featureHotelArrayData['hotel_image'] = $url;
            } catch (Exception $e) {
                $return['message'] = 'Error during save image banner :' . $e->getMessage();
            }
        }
        try {
            DB::beginTransaction();
            $featureHotelTypeData = FeatureHotel::create($featureHotelArrayData);
            DB::commit();
            if ($featureHotelTypeData) {
                $return['status'] = 1;
                $return['message'] = 'Featured Hotel "'. $requestData['hotel_name'] . '" have saved successfully';
                $return['data'] = $featureHotelTypeData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save Featured Hotels : ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateFeatureHotel($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {

            @$featureHotelTypeDetails = array(
                'id' => $requestData['id'],
                'hotel_name' => $requestData['hotel_name'],
                'hotel_name_ar' => $requestData['hotel_name_ar'],
                'hotel_link' => $requestData['hotel_link'],
                'location' => $requestData['location'],
                'location_ar' => $requestData['location_ar'],
                'hotel_image' => $requestData['hotel_image'],
                'price' => $requestData['price'],
                'rating' => $requestData['rating'],
                'hot_deal' => $requestData['hot_deal'],
                'status' => $requestData['status'],
            );
            if (strpos(request()->path(), 'api') === false && isset($requestData['hotel_image'])) {
                try {
                    $destinationPath = storage_path() . '/app/public/feature-hotel/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }

                    $file = $requestData['hotel_image'];
                    $image_resize = Image::make($requestData['hotel_image']);
                    $image_resize->resize(300, 300);
                    $fileName =  uniqid() . time() . '.' . $requestData['hotel_image']->extension();
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/feature-hotel/' . $fileName;
                    $featureHotelTypeDetails['hotel_image'] = $url;

                    if ($requestData['saved_hotel_image'] != '') {
                        $savedHotelImageArr = explode('/feature-hotel/', $requestData['saved_hotel_image']);
                        $fileName = $destinationPath.$savedHotelImageArr[1];
                        File::delete($fileName);
                    }
                } catch (Exception $e) {
                    $return['message'] = 'Error during update Featured Hotels :' . $e->getMessage();
                }
            } elseif (strpos(request()->path(), 'api') === false && $requestData['saved_hotel_image'] != '') {
                $requestData['hotel_image'] = $requestData['saved_hotel_image'];
            }
            try {

                DB::beginTransaction();
                $matchFeatureHotelType = ['id' => $featureHotelTypeDetails['id']];
                $FeatureHotelType = FeatureHotel::updateOrCreate($matchFeatureHotelType, $featureHotelTypeDetails);
                DB::commit();
                if ($FeatureHotelType) {
                    $return['status'] = 1;
                    $return['message'] = 'Featured Hotel "'. $requestData['hotel_name'] . '" have updated successfully';
                    $return['data'] = $FeatureHotelType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update Featured Hotels : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteFeatureHotel($featureHotelId)
    {

        $hotelDetails = FeatureHotel::find($featureHotelId)->toArray();
        if ($hotelDetails) {
            FeatureHotel::where('id', $featureHotelId)->delete();

            if ($hotelDetails['hotel_image'] != '') {
                $savedHotelImageArr = explode('/feature-hotel/', $hotelDetails['hotel_image']);
                $destinationPath = storage_path() . '/app/public/feature-hotel/';
                $fileName = $destinationPath.$savedHotelImageArr[1];
                File::delete($fileName);
            }

            $return['status'] = 1;
            $return['message'] = 'Featured Hotel "' . $hotelDetails['hotel_name'] . '" have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete the hotel. Please try again.';
        }
        return $return;
    }
}
