<?php


namespace App\Models;

use App\Enums\Currency;
use App\Enums\Locale;
use App\Traits\EmailService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use App\Models\CustomerAddresses;
use App\Models\GeoRegionLists;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Carbon;
use Laravel\Passport\HasApiTokens;
use App\Traits\Uuids;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Activitylog\Traits\LogsActivity;

class Customer extends Authenticatable
{
    protected $guarded = [];
    use HasFactory, Uuids, HasApiTokens, LogsActivity,EmailService, HasActivityLogging;
    protected static $logName = 'customers';
    protected $hidden = ['password'];



    public function getCustomerAddress()
    {
        return $this->hasOne(CustomerAddresses::class, 'customer_id', 'id')->with('getCountry', 'getState', 'getCity');
    }


    /**
     * get list or single or all record to display
     */
    public static function getCustomers($option = array())
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'mobile_verified' => '',
            'where' => array(),
            'orWhere' => array()
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = Customer::query();
                $query->with('getCustomerAddress');
                $query->select(
                    "customers.*",
                    DB::raw('(CASE WHEN customers.title = "mr" THEN "Mr" '
                        . 'WHEN customers.title = "mrs" THEN "Mrs" '
                        . 'WHEN customers.title = "miss" THEN "Miss" '
                        . 'END) AS display_title'),
                    DB::raw('(CASE WHEN customers.status = "inactive" THEN "In-Active" '
                        . 'WHEN customers.status = "active" THEN "Active" '
                        . 'WHEN customers.status = "deleted" THEN "Deleted" '
                        . 'WHEN customers.status = "terminated" THEN "Terminated" '
                        . 'END) AS customer_status_text'),
                );
                $query->where('customers.id', $config['id']);
                $result = $query->first();
                // echo "<pre>";print_r($result);die;
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = Customer::query();
                $query->with('getCustomerAddress');
                $query->select(
                    "customers.*",
                    DB::raw('(CASE WHEN customers.title = "mr" THEN "Mr" '
                        . 'WHEN customers.title = "mrs" THEN "Mrs" '
                        . 'WHEN customers.title = "miss" THEN "Miss" '
                        . 'END) AS display_title'),
                    DB::raw('(CASE WHEN customers.status = "inactive" THEN "In-Active" '
                        . 'WHEN customers.status = "active" THEN "Active" '
                        . 'WHEN customers.status = "deleted" THEN "Deleted" '
                        . 'WHEN customers.status = "terminated" THEN "Terminated" '
                        . 'END) AS customer_status_text'),
                );
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where($where[0], $where[1], $where[2]);
                    }
                }
                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }

                $result = $query->paginate($config['per_page']);
                $result->setPath('?per_page=' . $config['per_page']);
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        }
        if (!empty($result)) {
            $return['status'] = 1;
            $return['message'] = 'Customer list successfully';
            $return['data'] = $result;
            return $return;
        } else {
            return $return;
        }
    }

    /**
     * insert new record in database
     */
    public static function createCustomers($requestData)
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        if (isset($requestData['marriage_aniversary_date'])) {
            if ($requestData['marriage_aniversary_date'] == null) {
                $marriage_aniversary_date = null;
            } else {
                $marriage_aniversary_date = Carbon::parse($requestData['marriage_aniversary_date'])->format('Y-m-d');
            }
        } else {
            $marriage_aniversary_date = null;
        }
        try {
            $customerData = array(
                'first_name' => ucwords($requestData['first_name']),
                'title' => ucwords($requestData['title']),
                'last_name' => ucwords($requestData['last_name']),
                'mobile' => $requestData['isd_code'] . ' ' . $requestData['mobile'],
                'email' => $requestData['email'],
                'status' => $requestData['status'],
                'date_of_birth' => date('Y-m-d', strtotime($requestData['date_of_birth'])),
                'gender' => $requestData['gender'],
                'marital_status' => $requestData['marital_status'],
                'marriage_aniversary_date' => $marriage_aniversary_date,
                'profile_photo' => (@$requestData['profile_photo'] != "") ? $requestData['profile_photo'] : '',
                'alternative_email' => (@$requestData['alternative_email'] != "") ? $requestData['alternative_email'] : '',
                'user_currency' => (@$requestData['user_currency'] != "") ? $requestData['user_currency'] : Currency::SAR->value,
                'user_language' => (@$requestData['user_language'] != "") ? $requestData['user_language'] : Locale::English->value,

                'issue_date' => (@$requestData['issue_date'] != "") ? $requestData['issue_date'] : '',
                'emergency_contact_no' => '',
                'emergency_contact_title' => (@$requestData['emergencyContactTitle'] != "") ? $requestData['emergencyContactTitle'] : '',
                'emergency_contact_name' => (@$requestData['emergencyContactName'] != "") ? $requestData['emergencyContactName'] : '',
                'show_supplier_name' => (@$requestData['show_supplier_name'] != "") ? $requestData['show_supplier_name'] : '',
                 'password' => (isset($requestData['password']) && $requestData['password']!= "") ? Hash::make($requestData['password']) : '',
            );
            if (@$requestData['emergencyPhoneCode'] != "" && @$requestData['emergencyPhoneNumber'] != "") {
                $customerData['emergency_contact_no'] = $requestData['emergencyPhoneCode'] . ' ' . $requestData['emergencyPhoneNumber'];
            }

            $customerAddressData = array(
                'customer_id' => 0,
                'address1' => $requestData['address1'],
                'address2' => $requestData['address2'],
                'country' => $requestData['country'],
                'state' => $requestData['state_code'],
                'city' => $requestData['city_code'],
                'pincode' => $requestData['pincode'],
            );
            if (isset($requestData['croppedImage']) && $requestData['croppedImage'] != "") {
                //upload image
                try {
                    $base64_image_path = $requestData['croppedImage'];
                    // Extract the data and MIME type from the data URI
                    list($data, $encoded_data) = explode(',', $base64_image_path);

                    // Determine the file extension from the MIME type
                    $mime_type_parts = explode(';', $data);
                    if (count($mime_type_parts) > 0) {
                        $mime_type = trim($mime_type_parts[0]);
                        $image_type = null;
                        if ($mime_type === 'image/jpeg' || $mime_type === 'image/jpg') {
                            $image_type = IMAGETYPE_JPEG;
                        } elseif ($mime_type === 'image/png') {
                            $image_type = IMAGETYPE_PNG;
                        } else {
                            // Default to a specific extension (e.g., '.png') if the MIME type is not recognized
                            $image_type = IMAGETYPE_PNG;
                        }

                        $extension = image_type_to_extension($image_type);
                    } else {
                        // Default to a specific extension (e.g., '.png') if no MIME type is provided
                        $extension = '.png';
                    }

                    // Decode the base64 data into binary image data
                    $image_data = base64_decode($encoded_data);
                    $destinationPath = storage_path() . '/app/public/customer/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }
                    $file = $image_data;
                    $image_resize = Image::make($image_data);
                    $fileName =  uniqid() . time() .  $extension;
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/customer/' . $fileName;
                    // $customerData['profile_photo'] = $url;
                    $customerData['profile_photo'] = 'storage/customer/' . $fileName;
                } catch (Exception $e) {
                    $return['message'] = 'Error during save image suppliers :' . $e->getMessage();
                }
            } else if (isset($requestData['profile_photo'])) {
                //upload image
                try {
                    $destinationPath = storage_path() . '/app/public/customer/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }
                    $file = $requestData['profile_photo'];
                    $image_resize = Image::make($requestData['profile_photo']);
                    $image_resize->resize(300, 300);
                    $fileName =  uniqid() . time() .  '.' . $requestData['profile_photo']->extension();
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/customer/' . $fileName;
                    // $customerData['profile_photo'] = $url;
                    $customerData['profile_photo'] = 'storage/customer/' . $fileName;
                } catch (Exception $e) {
                    $return['message'] = 'Error during save image suppliers :' . $e->getMessage();
                }
            }
            try {
                DB::beginTransaction();
                $customer = Customer::create($customerData);
                $customerAddressData['customer_id'] = $customer->id;
                $customerAddress = CustomerAddresses::create($customerAddressData);
                DB::commit();
                if ($customer) {
                    $return['status'] = 1;
                    $return['message'] = 'Customer [' . ucwords($customer->first_name) . ' ' . $customer->last_name . '] saved successfully';
                    $return['data'] = $customer;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    /**
     * update record in database
     */
    public static function updateCustomer($requestData)
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        if (isset($requestData['marriage_aniversary_date'])) {
            if ($requestData['marriage_aniversary_date'] == null) {
                $marriage_aniversary_date = null;
            } else {
                $marriage_aniversary_date = Carbon::parse($requestData['marriage_aniversary_date'])->format('Y-m-d');
            }
        } else {
            $marriage_aniversary_date = null;
        }

        try {
            $customerData = array(
                // 'id' => $requestData['customer_id'],
                'first_name' => ucwords($requestData['first_name']),
                'title' => ucwords($requestData['title']),
                'last_name' => ucwords($requestData['last_name']),
                'mobile' => $requestData['isd_code'] . ' ' . $requestData['mobile'],
                'email' => $requestData['email'],
                'status' => $requestData['status'],
                'date_of_birth' => date('Y-m-d', strtotime($requestData['date_of_birth'])),
                'gender' => $requestData['gender'],
                'marital_status' => $requestData['marital_status'],
                'marriage_aniversary_date' => $marriage_aniversary_date,
                'alternative_email' => (@$requestData['alternative_email'] != "") ? $requestData['alternative_email'] : '',
                'user_currency' => (@$requestData['user_currency'] != "") ? $requestData['user_currency'] : Currency::SAR->value,
                'user_language' => (@$requestData['user_language'] != "") ? $requestData['user_language'] : Locale::English->value,

                'issue_date' => (@$requestData['issue_date'] != "") ? $requestData['issue_date'] : '',
                'emergency_contact_no' => '',
                'emergency_contact_title' => (@$requestData['emergencyContactTitle'] != "") ? $requestData['emergencyContactTitle'] : '',
                'emergency_contact_name' => (@$requestData['emergencyContactName'] != "") ? $requestData['emergencyContactName'] : '',
                'show_supplier_name' => (@$requestData['show_supplier_name'] != "") ? $requestData['show_supplier_name'] : '',

            );

            if(isset($requestData['password']) && $requestData['password']!=''){
                $customerData['password'] = Hash::make($requestData['password']);
            }

            if (@$requestData['emergencyPhoneCode'] != "" && @$requestData['emergencyPhoneNumber'] != "") {
                $customerData['emergency_contact_no'] = $requestData['emergencyPhoneCode'] . ' ' . $requestData['emergencyPhoneNumber'];
            }

            $customerAddressData1 = array(
                'address1' => $requestData['address1'],
                'address2' => $requestData['address2'],
                'country' => $requestData['country'],
                'state' => $requestData['state_code'],
                'city' => $requestData['city_code'],
                'pincode' => $requestData['pincode'],

            );
            if (isset($requestData['croppedImage']) && $requestData['croppedImage'] != "") {

                //upload image
                try {
                    $base64_image_path = $requestData['croppedImage'];
                    // Extract the data and MIME type from the data URI
                    list($data, $encoded_data) = explode(',', $base64_image_path);

                    // Determine the file extension from the MIME type
                    $mime_type_parts = explode(';', $data);
                    if (count($mime_type_parts) > 0) {
                        $mime_type = trim($mime_type_parts[0]);
                        $image_type = null;
                        if ($mime_type === 'image/jpeg' || $mime_type === 'image/jpg') {
                            $image_type = IMAGETYPE_JPEG;
                        } elseif ($mime_type === 'image/png') {
                            $image_type = IMAGETYPE_PNG;
                        } else {
                            // Default to a specific extension (e.g., '.png') if the MIME type is not recognized
                            $image_type = IMAGETYPE_PNG;
                        }

                        $extension = image_type_to_extension($image_type);
                    } else {
                        // Default to a specific extension (e.g., '.png') if no MIME type is provided
                        $extension = '.png';
                    }

                    // Decode the base64 data into binary image data
                    $image_data = base64_decode($encoded_data);
                    $destinationPath = storage_path() . '/app/public/customer/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }

                    $file = $image_data;
                    $image_resize = Image::make($image_data);
                    $fileName =  uniqid() . time() . $extension;
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/customer/' . $fileName;
                    // $customerData['profile_photo'] = $url;
                    $customerData['profile_photo'] = 'storage/customer/' . $fileName;
                    if (isset($requestData['old_photo'])) {
                        $p = parse_url($requestData['old_photo']);


                        if ($p['path'] != "") {

                            $image_path = str_replace('/storage/', 'app/public/', $p['path']);
                            $image_path = storage_path($image_path);

                            if (file_exists($image_path)) {
                                unlink($image_path);
                            }
                        }
                    }
                } catch (Exception $e) {
                    $return['message'] = 'Error during save image customer :' . $e->getMessage();
                }
            } else if (isset($requestData['profile_photo'])) {

                //upload image
                try {

                    $destinationPath = storage_path() . '/app/public/customer/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }

                    $file = $requestData['profile_photo'];
                    $image_resize = Image::make($requestData['profile_photo']);
                    $image_resize->resize(300, 300);
                    $fileName =  uniqid() . time() . '.' . $requestData['profile_photo']->extension();
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/customer/' . $fileName;
                    // $customerData['profile_photo'] = $url;
                    $customerData['profile_photo'] = 'storage/customer/' . $fileName;
                    if (isset($requestData['old_photo'])) {
                        $p = parse_url($requestData['old_photo']);


                        if ($p['path'] != "") {

                            $image_path = str_replace('/storage/', 'app/public/', $p['path']);
                            $image_path = storage_path($image_path);

                            if (file_exists($image_path)) {
                                unlink($image_path);
                            }
                        }
                    }
                } catch (Exception $e) {
                    $return['message'] = 'Error during save image customer :' . $e->getMessage();
                }
            }
            //upload with no-image
            try {

                // echo
                // "<pre>";
                // print_r($requestData);
                // die;
                DB::beginTransaction();
                $matchCustomer = ['id' => $requestData['customer_id']];
                $customer = Customer::updateOrCreate($matchCustomer, $customerData);
                $matchRecordSecond1 = ['customer_id' => $requestData['customer_id']];
                $customer['address'] = CustomerAddresses::updateOrCreate($matchRecordSecond1, $customerAddressData1);
               
                if ($customer) {

                    if($requestData['password']){
                        $code = 'CUSTOMER_RESET_PASSWORD';
                        $agencyLogo = Setting::where('config_key', 'general|basic|colorLogo')->get('value')[0]['value'] ?? Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
                        $siteName = count(Setting::where('config_key', 'general|basic|siteName')->get('value')) > 0 ? Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'] : "Rehlte Tourism & Travel";
                        $agencyName = Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
                        $customerMailData = [
                            'customer_name' => $customer->first_name,
                            'agencyLogo' => $agencyLogo,
                            'agencyName' => $agencyName,
                            'otp' => $requestData['password'],
                            'otp_expire_minute' => '',
                            'site_name' => $siteName ?? ''
                        ];

                         $getCustomerSendOTPTemplate = EmailService::resetCustomerPasswordTemplate($code, $customerMailData, 'en');

                        if ($getCustomerSendOTPTemplate['status'] == 'false') {
                            return back()->with('error', $getCustomerSendOTPTemplate['error']);
                        } else {
                            $sendOTPSubject = $getCustomerSendOTPTemplate['data']['subject'];
                            $sendOTPMailData = $getCustomerSendOTPTemplate['data']['mailData'];                           
                            $files = [];
                            // set data in sendEmail function
                            $data = EmailService::sendEmail($customer->email, $sendOTPSubject, $sendOTPMailData, $files, $siteName);
                        }
                    }
                     DB::commit();
                    $return['status'] = true;
                    $return['message'] = 'Customer [' . $customer->first_name . ' ' . $customer->last_name . '] update successfully';
                    $customer->profile_photo = $customer->profile_photo ? url($customer->profile_photo) : null;
                    $return['data'] = $customer;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    /**
     * update record in database
     */
    public static function updateCustomerImage($requestData)
    {
        $return = [
            'status' => 0,
            'message' => 'Something went wrong',
            'data' => []
        ];

        DB::beginTransaction();

        try {
            $customerData = [];

            // Handle profile photo upload
            if (!empty($requestData['profile_photo']) && $requestData['profile_photo']->isValid()) {
                $file = $requestData['profile_photo'];
                $fileName = uniqid() . '_' . time() . '.' . $file->extension();
                $destinationPath = storage_path('app/public/customer/');

                if (!is_dir($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }

                // Resize and save image
                try {
                    $image = Image::make($file)->resize(300, 300);
                    $image->save($destinationPath . $fileName);
                } catch (Exception $e) {
                    DB::rollBack();
                    $return['message'] = 'Image processing failed: ' . $e->getMessage();
                    return $return;
                }

                $imageUrl = URL::to('/storage/customer/' . $fileName);
                // $customerData['profile_photo'] = $imageUrl;
                $customerData['profile_photo'] = 'storage/customer/' . $fileName;
                // Delete old photo if provided
                if (!empty($requestData['old_photo'])) {
                    $oldPath = parse_url($requestData['old_photo'], PHP_URL_PATH);
                    $oldStoragePath = storage_path('app/public' . str_replace('/storage', '', $oldPath));

                    if (file_exists($oldStoragePath)) {
                        @unlink($oldStoragePath); 
                    }
                }
            }

            // Update or create customer record
            $matchCustomer = ['id' => $requestData['customer_id']];
            $customer = Customer::updateOrCreate($matchCustomer, $customerData);

            DB::commit();

            $return['status'] = 1;
            $return['message'] = 'Customer [' . $customer->first_name . ' ' . $customer->last_name . '] image has been updated successfully.';
            $customer->profile_photo = $customer->profile_photo ? url($customer->profile_photo) : null;
            $return['data'] = $customer;
        } catch (Exception $e) {
            DB::rollBack();
            $return['message'] = 'Exception: ' . $e->getMessage();
        }

        return $return;
    }


    /**
     * delete record from database
     */
    public static function deleteCustomers($customer_id)
    {
        $is_dependent = Customer::checkDependancy($customer_id);
        $return = array(
            'status' => 0,
            'message' => 'Something went wrong'
        );

        $customerData = Customer::where('id', $customer_id)->first()->toArray();
        if ($is_dependent) {
            //update status to deleted
            Customer::where('id', $customer_id)->update(['status' => 2]);
            $return['status'] = 1;
            $return['message'] = 'Customer [' . $customerData['profile_photo'] . '] soft deleted successfully';
        } else {
            //delete record from table
            $p = parse_url($customerData['profile_photo']);
            if ($p['path'] != "") {
                $image_path = str_replace('/storage/', 'app/public/', $p['path']);
                $image_path = storage_path($image_path);

                if (file_exists($image_path)) {
                    unlink($image_path);
                }
            }

            Customer::where('id', $customer_id)->delete();
            $customerAddress = CustomerAddresses::where('customer_id', $customer_id)->get();
            if ($customerAddress) {
                CustomerAddresses::where('customer_id', $customer_id)->delete();
            }
            $return['status'] = 1;
            $return['message'] = 'Customer [' . $customerData['first_name'] . '] deleted successfully';
        }

        return $return;
    }
    public static function checkDependancy($customer_id)
    {
        /**
         * in future need to check dependancy to other reference table and need to set true if
         * any dependancy set in reference tables
         **/
        $dep_modules = [];

        return $dep_modules;
    }

    /**
     * get record for customer report
     */
    static public function getMasterCustomerReport($option = array(), $pagination = true, $getTotalPrice = false)
    {
        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'per_page' => 10, // Set a default value for per_page, adjust as needed
        );

        $config = array_merge($data, $option);
        $query = Customer::query();

        if (!empty($config['dates'])) {
            foreach ($config['dates'] as $dates) {
                $query->whereDate('created_at', '>=', $dates[0])->whereDate('created_at', '<=', $dates[1]);
            }
        }

        $query->orderBy($config['order_by'], $config['sorting']);
        if (!empty($config['where'])) {
            foreach ($config['where'] as $where) {
                $query->where($where[0], $where[1], $where[2]);
            }
        }


        if (!empty($config['orWhere'])) {
            foreach ($config['orWhere'] as $orWhere) {
                $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
            }
        }

        if ($pagination) {
            $result = $query->paginate($config['per_page']);
            $result->setPath('?per_page=' . $config['per_page']);
        } else {
            $result = $query->latest()->get();
        }


        return $result;
    }

    /**
     * get record for monthly customer report
     */
    static public function getMasterMonthlyCustomerReport($fromDate, $toDate)
    {

        // Get the data from the database
        $data = Customer::whereBetween(DB::raw('DATE(created_at)'), [$fromDate, $toDate])
            ->selectRaw('DATE_FORMAT(created_at, "%M, %Y") as month, COUNT(id)

                        as count')
            ->groupBy(DB::raw('DATE_FORMAT(created_at, "%M, %Y")'))
            ->get();

        // Create an associative array with month names as keys and counts as values
        $monthData = [];
        foreach ($data as $row) {
            $monthData[$row->month] = $row->count;
        }

        // Get all months between $fromDate and $toDate
        $start = Carbon::parse($fromDate);
        $end = Carbon::parse($toDate);
        $result = [];

        while ($start->lte($end)) {
            $formattedMonth = $start->format('F, Y');
            $count = isset($monthData[$formattedMonth]) ? $monthData[$formattedMonth] : 0;
            $result[] = ['month' => $formattedMonth, 'count' => $count];

            // Increment to the next month
            $start->addMonth();
        }
        return $result;
    }

    public static function deleteCustomer($customerId)
    {
        $return = array(
            'status' => 0,
            'message' => 'Something went wrong'
        );

        $travelerDetails = Customer::where('id', $customerId)->first();
        if ($travelerDetails) {
            try {
                DB::beginTransaction();
                $condition = ['id' => $customerId];
                $payload = ['status' => 'deleted'];
                $customer = Customer::updateOrCreate($condition, $payload);

                DB::commit();
                if ($customer) {
                    $return = array(
                        'status' => 1,
                        'message' => 'Customer have deleted successfully.'
                    );
                }
            } catch (\Exception $e) {
                $return['message'] = 'Unable to delete the customer. ' . $e->getMessage();
            }
        } else {
            $return['message'] = 'Unable to find the customer. Please try again.';
        }
        return $return;
    }

    public static function updateCustomerData($id, $requestData)
    {
        try {
            DB::beginTransaction();

            $customer = Customer::findOrFail($id);
            $matchCustomer = ['id' => $id];

            // Build customer data dynamically and safely
            $customerData = [];

            if (isset($requestData['first_name'])) {
                $customerData['first_name'] = ucwords($requestData['first_name']);
            }

            if (isset($requestData['last_name'])) {
                $customerData['last_name'] = ucwords($requestData['last_name']);
            }

            if (!empty($requestData['mobile']) && !empty($requestData['isd_code'])) {
                $customerData['mobile'] = $requestData['isd_code'] . ' ' . $requestData['mobile'];
            }

            if (!empty($requestData['date_of_birth'])) {
                $customerData['date_of_birth'] = date('Y-m-d', strtotime($requestData['date_of_birth']));
            }

            if (!empty($requestData['gender'])) {
                $customerData['gender'] = $requestData['gender'];
            }

            if (!empty($requestData['marital_status'])) {
                $customerData['marital_status'] = $requestData['marital_status'];
            }
            if (!empty($requestData['alternate_email'])) {
                $customerData['alternative_email'] = $requestData['alternate_email'];
            }
            if (!empty($requestData['user_currency'])) {
                $customerData['user_currency'] = $requestData['user_currency'];
            }
            if (!empty($requestData['user_language'])) {
                $customerData['user_language'] = $requestData['user_language'];
            }
            if (!empty($requestData['issue_date'])) {
                $customerData['issue_date'] = $requestData['issue_date'];
            }
            if (!empty($requestData['emergencyPhoneNumber'])) {
                $customerData['emergency_contact_no'] = $requestData['emergencyPhoneNumber'];
            }
            if (!empty($requestData['emergencyContactTitle'])) {
                $customerData['emergency_contact_title'] = $requestData['emergencyContactTitle'];
            }
            if (!empty($requestData['emergencyContactName'])) {
                $customerData['emergency_contact_name'] = $requestData['emergencyContactName'];
            }
            if (!empty($requestData['emergencyPhoneCode'])) {
                $customerData['emergency_contact_code'] = $requestData['emergencyPhoneCode'];
            }
            if (!empty($requestData['phoneCode'])) {
                $customerData['mobile_code'] = $requestData['phoneCode'];
            }



            // $customerData['issue_date'] = !empty($requestData['issue_date']) ? $requestData['issue_date'] : '';
            // $customerData['emergency_contact_no'] = $requestData['emergencyPhoneNumber'] ?? 0;
            // $customerData['emergency_contact_title'] = $requestData['emergencyContactTitle'] ?? '';
            // $customerData['emergency_contact_name'] = $requestData['emergencyContactName'] ?? '';
            // $customerData['emergency_contact_code'] = $requestData['emergencyPhoneCode'] ?? '';
            // $customerData['mobile_code'] = $requestData['phoneCode'] ?? '';



            // Address
            $existingAddress = CustomerAddresses::where('customer_id', $id)->first();
            $customerAddressData1 = [
                'customer_id' => $id,
                'address1' => isset($requestData['address1']) && $requestData['address1'] !== 'undefined'
                    ? $requestData['address1']
                    : ($existingAddress->address1 ?? ''),

                'address2' => isset($requestData['address2']) && $requestData['address2'] !== 'undefined'
                    ? $requestData['address2']
                    : ($existingAddress->address2 ?? ''),

                'country' => $requestData['country'] ?? ($existingAddress->country ?? ''),
                'state' => $requestData['state_code'] ?? ($existingAddress->state ?? ''),
                'city' => $requestData['city_code'] ?? ($existingAddress->city ?? ''),
                'pincode' => $requestData['pincode'] ?? ($existingAddress->pincode ?? ''),
            ];


            $customer = Customer::updateOrCreate($matchCustomer, $customerData);
            $customerAddress = CustomerAddresses::updateOrCreate(['customer_id' => $id], $customerAddressData1);

            DB::commit();

            if ($customer && $customerAddress) {
                $customer->profile_photo = $customer->profile_photo
                             ? asset($customer->profile_photo)
                             : null;

                $mergedData = array_merge(
                    $customer->toArray(),
                    $customerAddress->toArray()
                );

                return [
                    'status' => true,
                    'message' => 'Customer data has been updated successfully.',
                    'data' => $mergedData
                ];
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return [
                'status' => 0,
                'message' => 'Error during save user record: ' . $e->getMessage(),
                'data' => []
            ];
        }
    }
}
