<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    use HasFactory;
    protected $table = 'currencies';
    protected $guarded = [];


    public static function getCurrencySymbol($currency) {
        $currencySymbol = '';
        $currencySymbolResult = Currency::query()
                                        ->where('code', $currency)
                                        ->first();
        if ($currencySymbolResult) {
            $currencySymbol = $currencySymbolResult->symbol;
        }
        return $currencySymbol;
    }
}
