<?php

/**
 * @package     Offers
 * @subpackage  Coupon
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the Geography.
 */

namespace App\Models;

use DateTime;
use App\Traits\Uuids;
use App\Models\AirlineI18ns;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Traits\ClearsHomePageCache;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Coupon extends Model
{
    use HasFactory, LogsActivity, Uuids, SoftDeletes,ClearsHomePageCache,HasActivityLogging;
    protected $guarded = [];
    public function couponCodeName()
    {
        return $this->hasMany('App\Models\CouponI18ns', 'coupon_id', 'id');
    }
    public function applicableCustomer()
    {
        return $this->hasMany('App\Models\CouponApplicableCustomer', 'coupon_id', 'id');
    }
    public function serviceType()
    {
        return $this->hasMany('App\Models\ServiceType', 'id', 'service_type_id');
    }

    /**
     * get list or single or all record to display
     */
    public static function getCoupons($option = array())
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'where' => array(),
            'orWhere' => array(),
            'per_page' => 15,  // Default number of records per page
        );

        $config = array_merge($data, $option);
        $result = [];

        // Check if there's an ID filter for a specific coupon
        if ($config['id'] != '') {
            try {
                $query = Coupon::query();
                $query->withTrashed();  // Include trashed records (soft deletes)
                $query->with(['couponCodeName', 'applicableCustomer']);  // Eager loading relationships
                $query->select("coupons.*");  // Select all columns from coupons
                $query->where('id', $config['id']);  // Filter by coupon ID

                // Fetch the first record (no pagination needed)
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = Coupon::query();
                $query->withTrashed();  // Include trashed records
                $query->with(['couponCodeName', 'applicableCustomer']);  // Eager load relationships
                $query->select("coupons.*");

                // Apply the 'where' conditions passed in the options
                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where($where[0], $where[1], $where[2]);  // Apply where conditions
                    }
                }

                // Apply the 'orWhere' conditions passed in the options
                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);  // Apply 'or' conditions
                    }
                }

                // Apply sorting based on the 'order_by' and 'sorting' parameters
                if (in_array($config['order_by'], ['created_at', 'coupon_amount', 'from_date', 'to_date', 'minimum_spend', 'maximum_spend', 'limit_per_coupon', 'limit_per_customer'])) {
                    $query->orderBy($config['order_by'], $config['sorting']);  // Apply sorting
                }

                // Fetch the results with pagination (if per_page is set)
                $result = $query->paginate($config['per_page']);
                $result->setPath('?per_page=' . $config['per_page']);  // Set the path for pagination
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        }

        // Return the result, if any records found
        if (!empty($result)) {
            $return['status'] = 1;
            $return['message'] = 'Coupon list successfully';
            $return['data'] = $result;

            return $return;
        } else {
            return $return;  // Return the default error message if no records found
        }
    }
    /**
     * insert new record in database
     */
    public static function createCoupon($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        // if ($requestData['customer_type'] == 'B2C') {
        //     $selectedCustomer = 'Customer';
        //     if (isset($requestData['customer']) && $requestData['customer'] == '') {
        //         $selectedCustomer = 'Customer';
        //     }
        //     if (isset($requestData['customerAll']) && $requestData['customerAll'] == 'on') {
        //         $selectedCustomer = 'All Customer';
        //     }
        // } else if ($requestData['customer_type'] == 'B2B') {
        //     $selectedCustomer = 'Agency';
        //     if (isset($requestData['agency']) && $requestData['agency'] == '') {
        //         $selectedCustomer = 'Agency';
        //     }
        //     if (isset($requestData['agencyAll']) && $requestData['agencyAll'] == 'on') {
        //         $selectedCustomer = 'All Agency';
        //     }
        // }
        try {
            $couponData = array(
                // 'customer_type'  => $requestData['customer_type'],
                'coupon_code'  => $requestData['coupon_code'],
                'coupon_amount'  => !empty($requestData['coupon_amount']) && is_array($requestData['coupon_amount']) ? implode(",", array_filter($requestData['coupon_amount'])): 0,
                'discount_type'  => $requestData['discount_type'],
                'from_date'  => $requestData['from_date'],
                'to_date'  => $requestData['to_date'],
                'minimum_spend'  => !empty($requestData['minimum_spend']) && is_array($requestData['minimum_spend']) ? implode(",", array_filter($requestData['minimum_spend'])): 0,

                'maximum_spend'  => !empty($requestData['maximum_spend']) && is_array($requestData['maximum_spend']) ? implode(",", array_filter($requestData['maximum_spend'])): 0,
                // 'service_type_id'  => $requestData['service_type'],
                // 'customer'  => $selectedCustomer,
                'limit_per_coupon'  => $requestData['limit_per_coupon'],
                // 'limit_per_customer'  => $requestData['limit_per_customer'],
                'description'  => $requestData['description'],
                'status'  => $requestData['status'],
                'bank_name'  => $requestData['bank_name'],
                'bank_card_number'  => $requestData['bank_card_number'],
                'product'  => $requestData['product'],
                'airline_name'  => $requestData['airline_name'],
                'airline_cabin_class'  => $requestData['airline_cabin_class'],
                'hotel_name'  => $requestData['hotel_name'],
                'hotel_city'  => $requestData['hotel_city'],
                'domestic_product'  => $requestData['domestic_product'],
                'international_product'  => $requestData['international_product'],
                'payment_method'  => $requestData['payment_method'],
                'is_new'  => (array_key_exists('is_new', $requestData) ? $requestData['is_new'] : 0),
                'coupon_type' => $requestData['coupon_type'] ?? '',
                'expiry_date' => $requestData['expiry_date'] ?? '',
                'terms_en' => $requestData['terms_en'] ?? '',
                'terms_ar' => $requestData['terms_ar'] ?? '',
                'thumbnail' => $requestData['thumbnail'] ?? '',
                'banner' => $requestData['banner'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',


            );
            // if (isset($requestData['croppedImage']) && $requestData['croppedImage'] != "") {
            //     //upload image
            //     try {
            //         $base64_image_path = $requestData['croppedImage'];
            //         // Extract the data and MIME type from the data URI
            //         list($data, $encoded_data) = explode(',', $base64_image_path);

            //         // Determine the file extension from the MIME type
            //         $mime_type_parts = explode(';', $data);
            //         if (count($mime_type_parts) > 0) {
            //             $mime_type = trim($mime_type_parts[0]);
            //             $image_type = null;
            //             if ($mime_type === 'image/jpeg' || $mime_type === 'image/jpg') {
            //                 $image_type = IMAGETYPE_JPEG;
            //             } elseif ($mime_type === 'image/png') {
            //                 $image_type = IMAGETYPE_PNG;
            //             } else {
            //                 // Default to a specific extension (e.g., '.png') if the MIME type is not recognized
            //                 $image_type = IMAGETYPE_PNG;
            //             }

            //             $extension = image_type_to_extension($image_type);
            //         } else {
            //             // Default to a specific extension (e.g., '.png') if no MIME type is provided
            //             $extension = '.png';
            //         }

            //         // Decode the base64 data into binary image data
            //         $image_data = base64_decode($encoded_data);
            //         $destinationPath = storage_path() . '/app/public/coupon/';
            //         if (!is_dir($destinationPath)) {
            //             mkdir($destinationPath, 0777);
            //         }
            //         $file = $image_data;
            //         $image_resize = Image::make($image_data);
            //         $fileName =  uniqid() . time() .  $extension;
            //         $image_resize->save($destinationPath . $fileName);
            //         $url = URL::to('/storage/') . '/coupon/' . $fileName;
            //         $couponData['upload_image'] = $url;
            //     } catch (Exception $e) {
            //         $return['message'] = 'Error during save image suppliers :' . $e->getMessage();
            //     }
            // } else if (isset($requestData['upload_image'])) {
            //     //upload image
            //     try {
            //         $destinationPath = storage_path() . '/app/public/coupon/';
            //         if (!is_dir($destinationPath)) {
            //             mkdir($destinationPath, 0777);
            //         }
            //         $file = $requestData['upload_image'];
            //         $image_resize = Image::make($requestData['upload_image']);
            //         $image_resize->resize(300, 300);
            //         $fileName =  uniqid() . time() .  '.' . $requestData['upload_image']->extension();
            //         $image_resize->save($destinationPath . $fileName);
            //         $url = URL::to('/storage/') . '/coupon/' . $fileName;
            //         $couponData['upload_image'] = $url;
            //     } catch (Exception $e) {
            //         $return['message'] = 'Error during save image suppliers :' . $e->getMessage();
            //     }
            // }
            // save to table
            try {
                DB::beginTransaction();

                $CouponDetails = Coupon::create($couponData);


                // if ($CouponDetails) {
                //     if ($requestData['customer_type'] == 'B2B') {
                //         if (isset($CouponDetails['customer']) && $CouponDetails['customer'] != 'All Agency') {
                //             foreach ($requestData['agency'] as $agency_id) {
                //                 $applicableCouponData = array(
                //                     'coupon_id' => $CouponDetails->id,
                //                     'agency_id' => $agency_id,
                //                 );
                //                 CouponApplicableCustomer::create($applicableCouponData);
                //             }
                //         }
                //     }
                //     if ($requestData['customer_type'] == 'B2C') {

                //         if (isset($requestData['customer']) && $requestData['customer'] != 'All Customer') {
                //             foreach ($requestData['customer'] as $customer_id) {
                //                 $applicableCouponData = array(
                //                     'coupon_id' => $CouponDetails->id,
                //                     'customer_id' => $customer_id,
                //                 );
                //                 CouponApplicableCustomer::create($applicableCouponData);
                //             }
                //         }
                //     }
                //     $couponNames = $requestData['coupon_names'];
                //     foreach ($couponNames as $key => $name) {
                //         $nameData = array(
                //             'coupon_id' => $CouponDetails->id,
                //             'coupon_name' => $name['coupon_name'],
                //             'language_code' => $name['language_code']
                //         );
                //         CouponI18ns::create($nameData);

                //         $couponmsg[] = $name['coupon_name'];
                //     }

                //     $return['status'] = 1;
                //     $return['message'] = 'Coupon [' . implode(', ', $couponmsg) . '] saved successfully';

                //
                // }

                $return['status'] = 1;
                $return['message'] = 'Coupon  saved successfully';
                $return['data'] = $CouponDetails;

                DB::commit();
            } catch (\Exception $e) {
                $return['message'] = 'Error during save record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            // dd($e);
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    /**
     * update record into database
     */
    public static function updateCoupon($requestData)
    {

        // if ($requestData['customer_type'] == 'B2C') {
        //     $requestData['selectedCustomer'] = 'Customer';
        //     if (isset($requestData['customer']) && $requestData['customer'] == '') {
        //         $requestData['selectedCustomer'] = 'Customer';
        //     }
        //     if (isset($requestData['customerAll']) && $requestData['customerAll'] == 'on') {
        //         $requestData['selectedCustomer'] = 'All Customer';
        //     }
        // } else if ($requestData['customer_type'] == 'B2B') {
        //     $requestData['selectedCustomer'] = 'Agency';
        //     if (isset($requestData['agency']) && $requestData['agency'] == '') {
        //         $requestData['selectedCustomer'] = 'Agency';
        //     }
        //     if (isset($requestData['agencyAll']) && $requestData['agencyAll'] == 'on') {
        //         $requestData['selectedCustomer'] = 'All Agency';
        //     }
        // }
        try {
            $couponData = array(
                // 'customer_type'  => $requestData['customer_type'],
                'coupon_code'  => $requestData['coupon_code'],
                'coupon_amount'  => !empty($requestData['coupon_amount']) && is_array($requestData['coupon_amount']) ? implode(",", array_filter($requestData['coupon_amount'])): 0,
                'discount_type'  => $requestData['discount_type'],
                'from_date'  => $requestData['from_date'],
                'to_date'  => $requestData['to_date'],
                'minimum_spend'  => !empty($requestData['minimum_spend']) && is_array($requestData['minimum_spend']) ? implode(",", array_filter($requestData['minimum_spend'])): 0,

                'maximum_spend'  => !empty($requestData['maximum_spend']) && is_array($requestData['maximum_spend']) ? implode(",", array_filter($requestData['maximum_spend'])): 0,

                // 'service_type_id'  => $requestData['service_type'],
                //    'customer'  => $selectedCustomer,
                'limit_per_coupon'  => $requestData['limit_per_coupon'],
                //    'limit_per_customer'  => $requestData['limit_per_customer'],
                'description'  => $requestData['description'],
                'status'  => $requestData['status'],
                'bank_name'  => $requestData['bank_name'],
                'bank_card_number'  => $requestData['bank_card_number'],
                'product'  => $requestData['product'],
                'airline_name'  => $requestData['airline_name'],
                'airline_cabin_class'  => $requestData['airline_cabin_class'],
                'hotel_name'  => $requestData['hotel_name'],
                'hotel_city'  => $requestData['hotel_city'],
                'domestic_product'  => $requestData['domestic_product'],
                'international_product'  => $requestData['international_product'],
                'payment_method'  => $requestData['payment_method'],
                'is_new'  => (array_key_exists('is_new', $requestData) ? $requestData['is_new'] : 0),
                'coupon_type' => $requestData['coupon_type'] ?? '',
                'expiry_date' => $requestData['expiry_date'] ?? '',
                'terms_en' => $requestData['terms_en'] ?? '',
                'terms_ar' => $requestData['terms_ar'] ?? '',
                'thumbnail' => $requestData['thumbnail'] ?? '',
                'banner' => $requestData['banner'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',
            );
            // if (isset($requestData['croppedImage']) && $requestData['croppedImage'] != "") {
            //     //upload image
            //     try {
            //         $base64_image_path = $requestData['croppedImage'];
            //         // Extract the data and MIME type from the data URI
            //         list($data, $encoded_data) = explode(',', $base64_image_path);

            //         // Determine the file extension from the MIME type
            //         $mime_type_parts = explode(';', $data);
            //         if (count($mime_type_parts) > 0) {
            //             $mime_type = trim($mime_type_parts[0]);
            //             $image_type = null;
            //             if ($mime_type === 'image/jpeg' || $mime_type === 'image/jpg') {
            //                 $image_type = IMAGETYPE_JPEG;
            //             } elseif ($mime_type === 'image/png') {
            //                 $image_type = IMAGETYPE_PNG;
            //             } else {
            //                 // Default to a specific extension (e.g., '.png') if the MIME type is not recognized
            //                 $image_type = IMAGETYPE_PNG;
            //             }

            //             $extension = image_type_to_extension($image_type);
            //         } else {
            //             // Default to a specific extension (e.g., '.png') if no MIME type is provided
            //             $extension = '.png';
            //         }

            //         // Decode the base64 data into binary image data
            //         $image_data = base64_decode($encoded_data);
            //         $destinationPath = storage_path() . '/app/public/coupon/';
            //         if (!is_dir($destinationPath)) {
            //             mkdir($destinationPath, 0777);
            //         }
            //         $file = $image_data;
            //         $image_resize = Image::make($image_data);
            //         $fileName =  uniqid() . time() .  $extension;
            //         $image_resize->save($destinationPath . $fileName);
            //         $url = URL::to('/storage/') . '/coupon/' . $fileName;
            //         $couponData['upload_image'] = $url;
            //     } catch (Exception $e) {
            //         $return['message'] = 'Error during save image coupon :' . $e->getMessage();
            //     }
            // } else if (isset($requestData['upload_image'])) {
            //     //upload image
            //     try {
            //         $destinationPath = storage_path() . '/app/public/coupon/';
            //         if (!is_dir($destinationPath)) {
            //             mkdir($destinationPath, 0777);
            //         }
            //         $file = $requestData['upload_image'];
            //         $image_resize = Image::make($requestData['upload_image']);
            //         $image_resize->resize(300, 300);
            //         $fileName =  uniqid() . time() .  '.' . $requestData['upload_image']->extension();
            //         $image_resize->save($destinationPath . $fileName);
            //         $url = URL::to('/storage/') . '/coupon/' . $fileName;
            //         $couponData['upload_image'] = $url;
            //     } catch (Exception $e) {
            //         $return['message'] = 'Error during save image coupon :' . $e->getMessage();
            //     }
            // }
            // save to table
            try {
                DB::beginTransaction();

                $matchcouponData = ['id' => $requestData['coupon_id']];
                $updateCouponDetails = Coupon::updateOrCreate($matchcouponData, $couponData);


                // if ($updateCouponDetails) {
                //     if (isset($requestData['applicable_customer_id'])) {
                //         CouponApplicableCustomer::whereIn('id', $requestData['applicable_customer_id'])->delete();
                //     }
                //     if ($requestData['customer_type'] == 'B2C') {

                //         if ($updateCouponDetails['customer'] != 'All Customer') {

                //             foreach ($requestData['customer'] as $customer_id) {


                //                 $applicableCouponData = array(
                //                     'coupon_id' => $updateCouponDetails->id,
                //                     'customer_id' => $customer_id,
                //                 );
                //                 CouponApplicableCustomer::create($applicableCouponData);
                //             }
                //         }
                //     }
                //     if ($requestData['customer_type'] == 'B2B') {

                //         if ($updateCouponDetails['customer'] != 'All Agency') {

                //             foreach ($requestData['agency'] as $agency_id) {


                //                 $applicableCouponData = array(
                //                     'coupon_id' => $updateCouponDetails->id,
                //                     'agency_id' => $agency_id,
                //                 );
                //                 CouponApplicableCustomer::create($applicableCouponData);
                //             }
                //         }
                //     }
                //     $couponNames = $requestData['coupon_names'];
                //     foreach ($couponNames as $key => $name) {
                //         $nameData = array(
                //             'coupon_id' => $updateCouponDetails->id,
                //             'coupon_name' => $name['coupon_name'],
                //             'language_code' => $name['language_code']
                //         );
                //         $matchcouponDataapp = ['id' => $name['coupon_i18ns_id']];
                //         CouponI18ns::updateOrCreate($matchcouponDataapp,$nameData);

                //         $couponmsg[] = $name['coupon_name'];
                //     }

                //     $return['status'] = 1;
                //     $return['message'] = 'Coupon [' . implode(', ', $couponmsg) . '] updated successfully';

                //     $return['data'] = $updateCouponDetails;
                // }

                $return['status'] = 1;
                $return['message'] = 'Coupon updated successfully';
                $return['data'] = $updateCouponDetails;




                DB::commit();
            } catch (\Exception $e) {
                $return['message'] = 'Error during save record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function updateCouponData($id, $data)
    {
        try {
            DB::beginTransaction();
            $condition = ['id' => $id];
            $updateCouponDetails = Coupon::updateOrCreate($condition, $data);
            DB::commit();

            $return['status'] = 1;
            $return['message'] = 'Coupon updated successfully';
            $return['data'] = $updateCouponDetails;
        } catch (\Exception $e) {
            $return['message'] = 'Error during save record : ' . $e->getMessage();
        }
    }

    /**
     * remove record from database
     */
    public static function deleteCoupons($delete_coupon_id)
    {
        $return = array(
            'status' => 0,
            'message' => 'Something went wrong'
        );

        // Check if the coupon exists (using raw query to check)
        $couponData = DB::table('coupons')->where('id', $delete_coupon_id)->first();

        if (!$couponData) {
            $return['message'] = 'Coupon not found';
            return $return;
        }

        try {
            // Delete the coupon using raw query
            $deleted = DB::table('coupons')->where('id', $delete_coupon_id)->delete();

            if ($deleted) {
                $return['status'] = 1;
                $return['message'] = 'Coupon deleted successfully';
            } else {
                $return['message'] = 'Coupon could not be deleted';
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error occurred during deletion: ' . $e->getMessage();
        }

        return $return;
    }






    public static function checkDependancy($code, $delete_coupon_id)
    {
        /**
         * in future need to check dependancy to other reference table and need to set true if
         * any dependancy set in reference tables
         **/
        $dep_modules = [];

        return $dep_modules;
    }

    /**
     * restore deleted record
     **/
    public static function restoreCoupons($restore_coupon_id)
    {

        $return = array(
            'status' => 0,
            'message' => 'Something went wrong'
        );

        $couponData = Coupon::withTrashed()->find($restore_coupon_id);
        if ($couponData) {
            $couponData->restore();
            $return['status'] = 1;
            $return['message'] = 'Coupon [' . $couponData['coupon_code'] . '] restored successfully';
        }
        return $return;
    }
}
