<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use App\Traits\Uuids;
use App\Models\Customers;
use App\Models\CustomerTraveller;
use App\Models\Payment;

class Bookings extends Model
{
    use HasFactory, Uuids;
    protected $table = 'bookings';
    protected $guarded = [];

    protected $fillable = ['booking_ref', 'rehtle_ref', 'ref_id', 'booking_type', 'supplier_booking_ref', 'supplier_booking_associated_ref', 'ticket_numbers', 'booking_segment_id', 'supplier_id', 'supplier_name', 'service_id', 'booking_date', 'booking_start_date', 'customer_id', 'is_guest', 'first_name', 'last_name', 'email', 'phone_country_code', 'phone', 'agency_id', 'description', 'booking_points', 'redeem_points', 'sub_total', 'tax', 's_markup_fee', 's_service_fee', 's_markup_service_fee', 's_tax', 's_charge', 's_discount_type', 's_discount_value', 's_discount', 't_discount_type', 't_discount_value', 't_discount', 't_markup_type', 't_markup_value', 't_markup', 'chargeable_seat_price', 'travelers_price', 'redeem_amount', 'total', 'booking_cancel_amount', 'processed_cancel_amount', 'booking_details', 'booking_status', 'booking_sub_status', 'booking_status_message', 'supplier_currency', 'customer_currency', 'currency_conversion_rate', 'currency_markup', 'customer_language_code', 'billing_address1', 'billing_address2', 'billing_city', 'billing_state', 'billing_country', 'billing_zip', 'booking_request_payload', 'service_provider_request', 'service_provider_response', 'service_provider_issuance_response', 'service_provider_cancel_response', 'booking_from', 'addon_added', 'addon_amount', 'coupon_used', 'coupon_code', 'coupon_amount', 'wallet_used', 'wallet_amount', 'redeem_used', 'redeem_amount', 'service_provider', 'additional_details', 'booking_cancel_at', 'email_notification', 'sms_notification', 'whatsapp_notification', 'ticket_issued', 'traacs_created', 'booking_processed'];

    public function bookingCheckout()
    {
        return $this->belongsTo(BookingCheckout::class, 'ref_id', 'ref_id');
    }

    public function payment()
    {
        return $this->hasOne(Payment::class, 'booking_id');
    }

    public function passengers()
    {
        return $this->hasMany(CustomerTraveller::class, 'booking_id');
    }

    public function additionalDetails()
    {
        return $this->hasOne(BookingAdditionalDetail::class, 'booking_id');
    }

    /**
     * get list or single or all records to display
     */
    public static function getBookings($option = array())
    {
        $return = [
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        ];

        $data = [
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => [],
            'orWhere' => [],
            'whereHas' => [],
            'per_page' => 15
        ];

        $config = array_merge($data, $option);
        $result = [];

        try {
            $query = Bookings::with([
                'payment',  
                'passengers',  
                // 'additionalDetails'
            ])->select('bookings.*');

            // single booking by id
            if ($config['id'] != '') {
                $query->where('id', $config['id']);
                $result = $query->first();
            } else {
                $isSingleResult = false;

                // ordering logic
                if ($config['order_by'] == 'service_id') {
                    $query->join('core_service_types as c', 'bookings.service_id', '=', 'c.id')
                        ->orderBy('c.name', $config['sorting']);
                } elseif ($config['order_by'] == 'supplier_id') {
                    $query->join('core_suppliers as c', 'bookings.supplier_id', '=', 'c.id')
                        ->orderBy('c.name', $config['sorting']);
                } elseif ($config['order_by'] == 'customer_id') {
                    $query->join('customers as c', 'bookings.customer_id', '=', 'c.id')
                        ->orderBy('c.first_name', $config['sorting']);
                } elseif ($config['order_by'] == 'agency_id') {
                    $query->join('agencies as a', 'bookings.agency_id', '=', 'a.id')
                        ->orderBy('a.full_name', $config['sorting']);
                } else {
                    $query->orderBy($config['order_by'], $config['sorting']);
                }

                // apply where filters
                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        if ($where[0] == 'booking_ref') {
                            $isSingleResult = true;
                        }
                        $query->where('bookings.' . $where[0], $where[1], $where[2]);
                    }
                }

                // whereHas filters
                if (!empty($config['whereHas'])) {
                    $query->whereHas('getCustomer', function ($channelQuery) use ($config) {
                        foreach ($config['whereHas'] as $w) {
                            $channelQuery->where($w[0], $w[1], $w[2]);
                        }
                    });
                }

                // orWhere filters
                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }

                if ($isSingleResult) {
                    $result = $query->first();
                } else {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                }
            }

            if (!empty($result)) {
                return [
                    'status' => 1,
                    'message' => 'Booking list successfully',
                    'data' => $result
                ];
            }
        } catch (\Exception $e) {
            $return['message'] = $e->getMessage();
        }

        return $return;
    }


    /**
     * insert new record in database
     */
    public static function createBookingOld($bookingData, $requestData)
    {
        $return = array(
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            $bookingDetails = $requestData['bookingDetails'];
            $userDetails = $requestData['userDetails'];
            $paymentDetails = $requestData['paymentDetails'];
            //$hotelBookingDetails = $requestData['hotelBookingDetails'];
            //$flightBookingDetails = $requestData['flightBookingDetails'];

            // $flightDetails = $requestData['flightDetails'];
            // $passengerDetails = $requestData['passengerDetails'];
            // $seatDetails = $requestData['seatDetails'];
            // $packageDetails = $requestData['packageDetails'];

            // $bookingsData = array(
            //     'customer_id' => $requestData['customer_id'],
            //     'title' => $requestData['title'],
            //     'first_name' => ucwords($requestData['first_name']),
            //     'second_name' => $requestData['second_name'] ? $requestData['second_name'] : '',
            //     'last_name' => ucwords($requestData['last_name']),
            //     'date_of_birth' => date('Y-m-d', strtotime($requestData['date_of_birth'])),
            //     'gender' => $requestData['gender'],
            //     'nationality_id' => $requestData['nationality_id'],
            //     'id_type' => $requestData['id_type'],
            //     'id_number' => $requestData['id_number'],
            //     'issue_date' => date('Y-m-d', strtotime($requestData['issue_date'])),
            //     'expiry_date' => date('Y-m-d', strtotime($requestData['expiry_date'])),
            //     'country_id' => $requestData['country_id'],
            //     'status' => $requestData['status'],
            // );

            try {
                DB::beginTransaction();
                $booking = Bookings::create($bookingData);

                $result = array('booking' => $booking);

                if ($booking) {
                    $result['passengers'] = [];
                    foreach ($requestData['passengerDetails'] as $passenger) {
                        $passenger['customer_id'] = '';
                        $passenger['booking_id'] = $booking['id'];
                        $savedPassenger = CustomerTraveller::create($passenger);
                        array_push($result['passengers'], $savedPassenger['data']);
                    }
                }
                DB::commit();
                if ($booking) {

                    $return['status'] = 'true';
                    $return['message'] = 'Bookings have created successfully';
                    $return['data'] = $result;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function createBooking($bookingData)
    {
        $return = array(
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            DB::beginTransaction();
            $booking = Bookings::create($bookingData);
            DB::commit();
            if ($booking) {

                $return['status'] = 'true';
                $return['message'] = 'Bookings have created successfully';
                $return['data'] = $booking;
            } else {
                $return['message'] = 'Error during save user record';
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateBooking($bookingId, $data)
    {
        $result = [
            'status' => false,
            'data' => '',
            'message' => ''
        ];
        try {
            DB::beginTransaction();
            $booking = Bookings::updateOrCreate(['id' => $bookingId], $data);
            DB::commit();
            if ($booking) {
                $result['status'] = 'true';
                $result['data'] = $booking;
            } else {
                $result['message'] = 'Unable to update booking data';
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $result;
    }

    public static function getBooking($whereConditions = [])
    {
        $result = [
            'status' => false,
            'data' => '',
            'message' => ''
        ];
        $bookingQuery = Bookings::query();
        if (count($whereConditions) > 0) {
            foreach ($whereConditions as $where) {
                $bookingQuery->where($where['field'], $where['condition'], $where['value']);
            }
        }
        $booking = $bookingQuery->get();
        if ($booking) {
            $booking = $booking->toArray();
            $result['status'] = 'true';
            $result['data'] = $booking;
        } else {
            $result['message'] = 'Unable to update booking data';
        }
        return $result;
    }
}
