<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingStatusLog extends Model
{
    use HasFactory;
    protected $table = 'booking_status_log';
    protected $fillable = ['booking_id','booking_status_from','booking_status_to','booking_status_description', 'modified_by', 'refund_amount'];

    public function user(){
           return $this->belongsTo(User::class, 'modified_by');
    }
}
