<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Traits\Uuids;

class BookingHistory extends Model
{
    use HasFactory, Uuids;
    protected $table = 'booking_history';
    protected $guarded = [];

    protected $fillable = ['booking_id', 'booking_status', 'booking_sub_status', 'booking_status_message'];

    public function booking()
    {
        return $this->belongsTo(Bookings::class, 'booking_id');
    }

    /**
     * insert new record in database
     */
    public static function createBookingHistory($payload)
    {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            try {
                DB::beginTransaction();
                $bookingHistoryDetails = BookingHistory::create($payload);
                DB::commit();
                if ($bookingHistoryDetails) {
                    $return['status'] = 'true';
                    $return['message'] = 'Booking history have created successfully';
                    $return['data'] = $bookingHistoryDetails;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateBookingHistory($id, $payload)
    {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            try {
                DB::beginTransaction();
                $bookingHistoryDetails = BookingHistory::updateOrCreate(['id' => $id], $payload);
                DB::commit();
                if ($bookingHistoryDetails) {
                    $return['status'] = 'true';
                    $return['message'] = 'Booking history have updated successfully';
                    $return['data'] = $bookingHistoryDetails;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function getBookingHistory()
    {

        $bookingHistoryDetails = BookingHistory::with([
            'booking:id,booking_type,first_name,last_name,email,phone,booking_status,total,supplier_currency'
        ])->get();

        $bookingHistory = [];

        foreach ($bookingHistoryDetails as $history) {
            $booking = $history->booking;

            $bookingHistory[] = [
                'id' => $history->id,
                'booking_id' => $history->booking_id,
                'ref_id' => $history->ref_id,
                'booking_type' => $booking->booking_type ?? null,
                'customer_id' => $history->customer_id,
                'first_name' => $booking->first_name ?? null,
                'last_name' => $booking->last_name ?? null,
                'email' => $booking->email ?? null,
                'phone_no' => $booking->phone ?? null,
                'status' => $booking->booking_status ?? null,
                'amount' => $booking->total ?? 0,
                'currency' => $booking->supplier_currency ?? null,
                'booking_sub_status' => $history->booking_sub_status,
                'created_at' => $history->created_at,
            ];
        }

        return $bookingHistory;
    }
}
