<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Carbon;
use Intervention\Image\ImageManagerStatic as Image;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class BestOffer extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'best_offers';

    protected $guarded = [];

    protected static $logName = 'best_offers';
    protected $fillable = ['offer_title', 'offer_title_ar', 'offer_content', 'offer_content_ar', 'offer_link', 'offer_image', 'status'];

    /**
     * ger list or single or all records to display
     */
    public static function getBestOffers($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
	    if ($config['id'] != '') {
            try {
                $query = BestOffer::query();
                $query->select('best_offers.*');
                $query->where('best_offers.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = BestOffer::query();
                $query->select('best_offers.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('best_offers.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Best Offer list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createBestOffer($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $bestOfferArrayData = array(
            'offer_title' => $requestData['offer_title'],
            'offer_title_ar' => $requestData['offer_title_ar'],
            'offer_content' => $requestData['offer_content'],
            'offer_content_ar' => $requestData['offer_content_ar'],
            'offer_link' => $requestData['offer_link'],
            'offer_image' => $requestData['offer_image'],
            'status' => $requestData['status'],
        );
        if (strpos(request()->path(), 'api') === false && isset($requestData['offer_image'])) {
            //upload image
            try {
                $destinationPath = storage_path() . '/app/public/best-offers/';
                if (!is_dir($destinationPath)) {
                    mkdir($destinationPath, 0777);
                }

                $file = $requestData['offer_image'];
                $image_resize = Image::make($requestData['offer_image']);
                $image_resize->resize(300, 300);
                $fileName =  uniqid() . time() . '.' . $requestData['offer_image']->extension();
                $image_resize->save($destinationPath . $fileName);
                $url = URL::to('/storage/') . '/best-offers/' . $fileName;
                $bestOfferArrayData['offer_image'] = $url;
            } catch (Exception $e) {
                $return['message'] = 'Error during save image banner :' . $e->getMessage();
            }
        }
        try {
            DB::beginTransaction();
            $bestOfferData = BestOffer::create($bestOfferArrayData);
            DB::commit();
            if ($bestOfferData) {
                $return['status'] = 1;
                $return['message'] = 'Best Offer "'. $requestData['offer_title'] . '" have created successfully';
                $return['data'] = $bestOfferData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save Featured BestOffers : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateBestOffer($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {

            @$bestOfferTypeDetails = array(
                'id' => $requestData['id'],
                'offer_title' => $requestData['offer_title'],
                'offer_title_ar' => $requestData['offer_title_ar'],
                'offer_content' => $requestData['offer_content'],
                'offer_content_ar' => $requestData['offer_content_ar'],
                'offer_link' => $requestData['offer_link'],
                'offer_image' => $requestData['offer_image'],
                'status' => $requestData['status'],
            );
            if (strpos(request()->path(), 'api') === false && isset($requestData['offer_image'])) {
                try {
                    $destinationPath = storage_path() . '/app/public/best-offers/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }

                    $file = $requestData['offer_image'];
                    $image_resize = Image::make($requestData['offer_image']);
                    $image_resize->resize(300, 300);
                    $fileName =  uniqid() . time() . '.' . $requestData['offer_image']->extension();
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/best-offers/' . $fileName;
                    $bestOfferTypeDetails['offer_image'] = $url;

                    if ($requestData['saved_offer_image'] != '') {
                        $savedOfferImageArr = explode('/best-offers/', $requestData['saved_offer_image']);
                        $fileName = $destinationPath.$savedOfferImageArr[1];
                        File::delete($fileName);
                    }
                } catch (Exception $e) {
                    $return['message'] = 'Error during update Featured BestOffers :' . $e->getMessage();
                }
            } elseif (strpos(request()->path(), 'api') === false && $requestData['saved_offer_image'] != '') {
                $requestData['offer_image'] = $requestData['saved_offer_image'];
            }
            try {

                DB::beginTransaction();
                $matchBestOfferType = ['id' => $bestOfferTypeDetails['id']];
                $BestOfferType = BestOffer::updateOrCreate($matchBestOfferType, $bestOfferTypeDetails);
                DB::commit();
                if ($BestOfferType) {
                    $return['status'] = 1;
                    $return['message'] = 'Best Offer "'. $requestData['offer_title'] . '" have updated successfully';
                    $return['data'] = $BestOfferType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update Featured BestOffers : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteBestOffer($bestOfferId)
    {

        $bestOfferDetails = BestOffer::where('id', $bestOfferId)->first()->toArray();
        if ($bestOfferDetails) {
            BestOffer::where('id', $bestOfferId)->delete();

            if ($bestOfferDetails['offer_image'] != '') {
                $savedOfferImageArr = explode('/best-offers/', $bestOfferDetails['offer_image']);
                $destinationPath = storage_path() . '/app/public/best-offers/';
                $fileName = $destinationPath.$savedOfferImageArr[1];
                File::delete($fileName);
            }

            $return['status'] = 1;
            $return['message'] = 'Best Offer "' . $bestOfferDetails['offer_title'] . '" have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete best offer. Please try again.';
        }

        return $return;
    }
}
