<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Carbon;
use Intervention\Image\ImageManagerStatic as Image;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class ApiDAta extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'api_list';

    protected $guarded = [];

    protected static $logName = 'api_list';
    protected $fillable = ['api_category', 'api_title', 'api_url', 'api_method', 'is_header_auth', 'request_payload', 'success_response', 'error_response','description'];

    /**
     * ger list or single or all records to display
     */
    public static function getApiList($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
	    if ($config['id'] != '') {
            try {
                $query = ApiData::query();
                $query->select('api_list.*');
                $query->where('api_list.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = ApiData::query();
                $query->select('api_list.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('api_list.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } else {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'API list have listed successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createApi($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $requestPayload = array(
            'api_category' => $requestData['api_category'],
            'api_title' => $requestData['api_title'],
            'api_url' => $requestData['api_url'],
            'api_method' => $requestData['api_method'],
            'is_header_auth' => $requestData['is_header_auth'],
            'request_payload' => $requestData['request_payload'],
            'success_response' => $requestData['success_response'],
            'error_response' => $requestData['error_response'],
            'description' => $requestData['description'],
        );
        try {
            DB::beginTransaction();
            $apiData = ApiData::create($requestPayload);
            DB::commit();
            if ($requestPayload) {
                $return['status'] = 1;
                $return['message'] = 'API Endpoint "'. $requestData['api_title'] . '" have added successfully';
                $return['data'] = $apiData;
            } else {
                $return['status'] = 0;
                $return['message'] = 'Unable to add API endpoint. Please try again.';
                $return['data'] = [];
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during add API endpoint : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateApi($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        $requestPayload = array(
            'id' => $requestData['id'],
            'api_category' => $requestData['api_category'],
            'api_title' => $requestData['api_title'],
            'api_url' => $requestData['api_url'],
            'api_method' => $requestData['api_method'],
            'is_header_auth' => $requestData['is_header_auth'],
            'request_payload' => $requestData['request_payload'],
            'success_response' => $requestData['success_response'],
            'error_response' => $requestData['error_response'],
            'description' => $requestData['description'],
        );
        try {

            DB::beginTransaction();
            $matchApiDataType = ['id' => $requestPayload['id']];
            $ApiDataType = ApiData::updateOrCreate($matchApiDataType, $requestPayload);
            DB::commit();
            if ($ApiDataType) {
                $return['status'] = 1;
                $return['message'] = 'API Endpoint "'. $requestData['api_title'] . '" have updated successfully';
                $return['data'] = $ApiDataType;
            } else {
                $return['status'] = 0;
                $return['message'] = 'Unable to update API Endpoint. Pleas try again';
                $return['data'] = [];
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during update API Endpoint : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteApiData($apiId)
    {

        $apiDetails = ApiData::where('id', $apiId)->first()->toArray();
        if ($apiDetails) {
            ApiData::where('id', $apiId)->delete();
            $return['status'] = 1;
            $return['message'] = 'API Endpoint "' . $apiDetails['api_title'] . '" have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete API Endpoint. Please try again.';
        }

        return $return;
    }
}
