<?php

namespace App\Jobs;

use App\Models\HotelAddress;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ImportHotelToElastic implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $chunkSize;

    public function __construct($chunkSize = 1000)
    {
        $this->chunkSize = $chunkSize;
    }

    public function handle()
    {
        // Process hotels in chunks
        HotelAddress::chunk($this->chunkSize, function ($hotels) {
            $hotels->searchable(); 
        });
    }
}
