<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use App\Jobs\UpdateLangJsonFilesJob;
use Maatwebsite\Excel\Concerns\ToCollection;

class TranslateImport implements ToCollection
{
    public $insertedCount = 0;
    public $skippedCount = 0;
    public $insertedItems = [];
    public $skippedItems = [];

    /**
     * Handle Excel rows
     */
    public function collection(Collection $collection)
    {
        // Remove the heading row
        $rows = $collection->skip(1);

        $keys = [];
        $valueEnglish = [];
        $valueArabic = [];

        foreach ($rows as $row) {
            // Expecting columns: [Key, Value English, Value Arabic]
            $key = trim($row[0] ?? '');
            $en  = trim($row[1] ?? '');
            $ar  = trim($row[2] ?? '');

            if ($key !== '') {
                $keys[] = $key;
                $valueEnglish[] = $en;
                $valueArabic[] = $ar;
            }
        }

        // Dispatch job
        if (!empty($keys)) {
            UpdateLangJsonFilesJob::dispatch($keys, $valueEnglish, $valueArabic);
        }
    }
}
