<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Queue;
use App\Jobs\SendCampaignMail;

class CampaignEmailsImport implements ToCollection
{
    protected $mailContents;

    public function __construct($mailContents)
    {
        $this->mailContents = $mailContents;
    }

    public function collection(Collection $rows)
    {
        $rows->shift(); // Skip the header row
        $emails = [];

        foreach ($rows as $row) {
            $id = trim($row[0] ?? '');
            $name = trim($row[1] ?? '');
            $email = trim($row[2] ?? '');

            if (!empty($name) && filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $emails[$email] = [
                    'email' => $email,
                    'name' => $name,
                    'id' => $id
                ];
            }
        }

        foreach ($emails as $emailData) {
            Queue::push(new SendCampaignMail($emailData, $this->mailContents));
        }
    }
}
