<?php

namespace App\Http\Middleware;

use App\Enums\Locale;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use App\Traits\CommonService;

class Language
{
    use CommonService;

    public function handle($request, Closure $next)
    {
        $languageCode = $request->session()->get('languageCode');

        if ($languageCode === null) {
            $appURL = env('APP_URL') . "/api/v1/core/languages";

            // Use libCurl from trait
            $response = $this->libCurl($appURL, 'GET', ['Content-Type: application/json']);

            $languageCode = Locale::English->value; // default
            if (!empty($response['data']['data'])) {
                foreach ($response['data']['data'] as $langCode) {
                    if (isset($langCode['is_default']) && $langCode['is_default'] == 1) {
                        $languageCode = $langCode['language_code'];
                        break;
                    }
                }
            }

            $request->session()->put('languageCode', $languageCode);
        }

        App::setLocale($languageCode);
        return $next($request);
    }
}
