<?php

use Carbon\Carbon;
use App\Models\City;
use App\Enums\Locale;
use App\Enums\ServiceType;
use App\Models\State;
use App\Models\Airport;
use App\Models\Country;
use App\Models\Markups;
use App\Models\Setting;
use App\Models\CityI18n;
use App\Models\Currency;
use App\Models\Language;
use App\Models\Suppliers;
use App\Models\CountryI18ns;
use App\Models\DefaultMarkup;
use App\Models\InvoiceSetting;
use Illuminate\Support\Facades\Storage;

function setDetaultLanguage($languageCode)
{
    session(['languageCode' => ""]);
    session(['languageCode' => $languageCode]);
}


/**
 * get Country name list.
 *
 * @param  string  $term
 * @param int $page
 * @return \Illuminate\Http\Response
 */
function getCountryName($term, $page, $critetiaName = null)
{

    $resultsPerPage = 10;
    $offset = ($page - 1) * $resultsPerPage;
    $query = Country::with(['countryCode' => function ($query) {
        $query->orderBy('country_name', 'asc');
    }]);

    if ($term) {
        $query->whereHas('countryCode', function ($query) use ($term) {
            $query->where('country_name', 'like', '%' . $term . '%');
        });
    }
    $query->orderBy('iso_code', 'asc');
    $query->offset($offset)->limit($resultsPerPage);
    $countries = $query->get();

    $data = [];
    foreach ($countries as $country) {
        $cname = [];
        if (!empty($country['countryCode'])) {
            foreach ($country['countryCode'] as $country_name) {
                $cname[] = $country_name['country_name'] . ' ';
            }
        }
        $data[] = ['iso_code' => $country['iso_code'], 'cname' => $cname, 'first_page' => $critetiaName['page']];
    }

    return response()->json($data);
}

/**
 * get city name depend on country list.
 *
 * @param  string  $term
 * @param int $page
 * @return \Illuminate\Http\Response
 */
function getCityName($term, $page, $country_code)
{

    $resultsPerPage = 10;
    $offset = ($page - 1) * $resultsPerPage;
    $query = City::with(['cityCode' => function ($q) {
        $q->orderBy('city_name', 'asc');
    }]);

    if ($term) {
        $query->whereHas('cityCode', function ($query) use ($term) {
            $query->where('city_name', 'like', '%' . $term . '%');
        });
    }
    $query->orderBy('iso_code', 'asc');
    $query->where('country_code', $country_code);
    $query->offset($offset)->limit($resultsPerPage);
    $cities = $query->get();

    $data = [];
    foreach ($cities as $city) {
        $cname = [];
        if (!empty($city['cityCode'])) {
            foreach ($city['cityCode'] as $city_name) {
                $cname[] = $city_name['city_name'] . ' ';
            }
        }
        $data[] = ['iso_code' => $city['iso_code'], 'cname' => $cname];
    }

    return response()->json($data);
}

/**
 * get city name list.
 *
 * @param  string  $term
 * @param int $page
 * @return \Illuminate\Http\Response
 */
function getOnlyCityName($term, $page, $requestData)
{
    $resultsPerPage = 10;
    $offset = ($page - 1) * $resultsPerPage;
    $query = City::with(['cityCode' => function ($q) {
        $q->orderBy('city_name', 'asc');
    }]);

    if ($term) {
        $query->whereHas('cityCode', function ($query) use ($term) {
            $query->where('city_name', 'like', '%' . $term . '%');
        });
    }
    $query->orderBy('iso_code', 'asc');
    $query->offset($offset)->limit($resultsPerPage);
    $cities = $query->get();

    $data = [];
    foreach ($cities as $city) {
        $cname = [];
        if (!empty($city['cityCode'])) {
            foreach ($city['cityCode'] as $city_name) {
                $cname[] = $city_name['city_name'] . ' ';
            }
        }
        $data[] = ['iso_code' => $city['iso_code'], 'cname' => $cname, 'first_page' => $requestData['page']];
    }

    return response()->json($data);
}

/**
 * get state name depend on country list.
 *
 * @param  string  $term
 * @param int $page
 * @return \Illuminate\Http\Response
 */
function getStateName($term, $page, $country_code)
{

    $resultsPerPage = 10;
    $offset = ($page - 1) * $resultsPerPage;
    $query = State::with(['stateName' => function ($q) {
        $q->orderBy('state_name', 'asc');
    }]);

    if ($term) {
        $query->whereHas('stateName', function ($query) use ($term) {
            $query->where('state_name', 'like', '%' . $term . '%');
        });
    }
    $query->where('country_code', $country_code);
    $query->orderBy('iso_code', 'asc');
    $query->offset($offset)->limit($resultsPerPage);
    $states = $query->get();

    $data = [];
    foreach ($states as $state) {
        $sname = [];
        if (!empty($state['stateName'])) {
            foreach ($state['stateName'] as $state_name) {
                $sname[] = $state_name['state_name'] . ' ';
            }
        }
        $data[] = ['id' => $state['id'], 'sname' => $sname];
    }

    return response()->json($data);
}

/**
 * get number of nights for stay.
 */
function getNumberOfNights($hotelCheckInDate, $hotelCheckOutDate)
{
    $checkInDate = Carbon::createFromFormat('m-d-Y', $hotelCheckInDate);
    $checkOutDate = Carbon::createFromFormat('m-d-Y', $hotelCheckOutDate);
    $numberOfNights = $checkOutDate->diffInDays($checkInDate);

    return $numberOfNights;
}

function getLocationByIpAddressOld()
{
    try {

        $ip = $_SERVER['REMOTE_ADDR'];


        $url = "http://www.geoplugin.net/json.gp?ip=is_available_in_system:true";

        $headers = [
            'Content-Type: application/json',
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // execute!
        $response = curl_exec($ch);
        // close the connection, release resources used
        curl_close($ch);

        $apiData = json_decode($response);
        $isoCode = $apiData->geoplugin_currencyCode;
        $iso_code = Currency::where('code', $isoCode)->value('code');
        if ($iso_code) {
            $isd = true;
        } else {
            $isd = false;
        }
        $url = "http://www.geoplugin.net/json.gp?ip=is_available_in_system:" . $isd;

        $headers = [
            'Content-Type: application/json',
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // execute!
        $response = curl_exec($ch);
        // close the connection, release resources used
        curl_close($ch);

        $data = json_decode($response);

        return $data;
    } catch (\Exception $e) {
        error_log('Caught exception: ' . $e->getMessage());
    }
}
function replacePriceValues($price, $arrData = [])
{


    $convertedTotalPrice = convertCurrencyExchangeRate($price['total'], 'SAR', $arrData->data->currencyCode, []);

    //set requested currency into currency key
    $price['currency'] = $arrData->data->currencyCode;
    $price['total'] = strval($convertedTotalPrice['data']['convertedRate']);

    //get converted base price using traits
    $convertedBasePrice = convertCurrencyExchangeRate($price['base'], 'SAR', $arrData->data->currencyCode, []);
    $price['base'] = strval($convertedBasePrice['data']['convertedRate']);

    //get converted grandTotal using traits
    $convertedGrandTotal = convertCurrencyExchangeRate($price['grandTotal'], 'SAR', $arrData->data->currencyCode, []);
    $price['grandTotal'] = strval($convertedGrandTotal['data']['convertedRate']);
    $price['supplier'] = "AMADEUS";

    return $price;
}
function replaceTravelersPriceValues($price, $arrData = [])
{
    $currencyCode = optional($arrData->data)->currencyCode ?? $arrData->currencyCode;

    $convertedTotalPrice = convertCurrencyExchangeRate($price, 'SAR', $currencyCode, []);


    $price = strval($convertedTotalPrice['data']['convertedRate']);
    return $price;
}

/**
 * use $markupType varible it's either in percentage or fixed
 * use $markupValue it's amount based on $markupType
 * use $price variable which is the price on which we want to imaplement markup calculation
 * use $isDomestic variable it's either yes or no
 */
function priceWithMarkup($markupType, $markupValue, $price, $isDomestic)
{

    $generalVATPercentage = Setting::where('config_key', 'general|site|defaultVatPercentage')->get('value')[0]['value'];
    $pricesArr = [];
    if ($markupType == 'percentage') {
        $pricesArr['base_fare'] = ($isDomestic == 'yes') ? $price / (1 + $generalVATPercentage / 100)  * $markupValue / 100 : $price + ($price * $markupValue / 100);
        $pricesArr['base_fare+YQ'] =  ($price * $markupValue / 100) * $generalVATPercentage / 100;
    } else {
        $pricesArr['base_fare'] = ($isDomestic == 'yes') ?  $price / (1 + $generalVATPercentage / 100) + $markupValue : $price + $markupValue;
        $pricesArr['base_fare+YQ'] = $markupValue * $generalVATPercentage / 100;
    }
    $pricesArr['net_fare'] = $pricesArr['base_fare'] + $pricesArr['base_fare+YQ'];
    $pricesArr['total'] = $pricesArr['net_fare'];
    $pricesArr['markupAmount'] = $price * $markupValue / 100;


    return $pricesArr;
}
/**
 * use $markupType varible it's either in percentage or fixed
 * use $markupValue it's amount based on $markupType
 * use $price variable which is the price on which we want to imaplement markup calculation
 */
function priceForTravelersWithMarkup($markupType, $markupValue, $totalPrice, $basePrice, $isDomestic)
{
    $generalVATPercentage = Setting::where('config_key', 'general|site|defaultVatPercentage')->get('value')[0]['value'];
    $pricesArr = [];
    if ($markupType == 'percentage') {
        $pricesArr['service_fee'] = $totalPrice * $markupValue / 100;
    } else {
        $pricesArr['service_fee'] = $markupValue;
        $domesticPrice = $totalPrice / 1.15;
        $pricesArr['vat'] =  ($isDomestic == 'yes') ? ($domesticPrice * 15 / 100) : "";
    }
    // $pricesArr['total'] = $totalPrice + $pricesArr['service_fee'] + $pricesArr['vat'];
    $pricesArr['base'] = $basePrice;



    return $pricesArr;
}
/**
 * to generate random string for booking ref. id
 */
function generateUniqueRandomString($length = 20)
{
    return bin2hex(random_bytes(($length + 1) / 2));
}


function amountToWord($number, $currency = 'SAR', $locale = Locale::English->value)
{

    $currencyMapEn = [
        'INR' => ['main' => 'Rupees', 'sub' => 'Paise'],
        'USD' => ['main' => 'Dollars', 'sub' => 'Cents'],
        'EUR' => ['main' => 'Euros', 'sub' => 'Cents'],
        'GBP' => ['main' => 'Pounds', 'sub' => 'Pence'],
        'AED' => ['main' => 'Dirhams', 'sub' => 'Fils'],
        'SAR' => ['main' => 'Riyals', 'sub' => 'Halalas'],
    ];

    $currencyMapAr = [
        'INR' => ['main' => 'روبية', 'sub' => 'بايس'],
        'USD' => ['main' => 'دولار', 'sub' => 'سنت'],
        'EUR' => ['main' => 'يورو', 'sub' => 'سنت'],
        'GBP' => ['main' => 'جنيه', 'sub' => 'بنس'],
        'AED' => ['main' => 'درهم', 'sub' => 'فلس'],
        'SAR' => ['main' => 'ريال', 'sub' => 'هللة'],
    ];

    // Pick correct currency labels
    if ($locale == Locale::Arabic->value) {

        $mainUnit = $currencyMapAr[$currency]['main'] ?? 'ريال';
        $subUnit  = $currencyMapAr[$currency]['sub'] ?? 'هللة';
    } else {
        $mainUnit = $currencyMapEn[$currency]['main'] ?? 'Riyals';
        $subUnit  = $currencyMapEn[$currency]['sub'] ?? 'Halalas';
    }

    $no = (int)floor($number);
    $point = (int)round(($number - $no) * 100);

    $wordsEn = [
        0 => '',
        1 => 'one',
        2 => 'two',
        3 => 'three',
        4 => 'four',
        5 => 'five',
        6 => 'six',
        7 => 'seven',
        8 => 'eight',
        9 => 'nine',
        10 => 'ten',
        11 => 'eleven',
        12 => 'twelve',
        13 => 'thirteen',
        14 => 'fourteen',
        15 => 'fifteen',
        16 => 'sixteen',
        17 => 'seventeen',
        18 => 'eighteen',
        19 => 'nineteen',
        20 => 'twenty',
        30 => 'thirty',
        40 => 'forty',
        50 => 'fifty',
        60 => 'sixty',
        70 => 'seventy',
        80 => 'eighty',
        90 => 'ninety'
    ];

    $wordsAr = [
        0 => '',
        1 => 'واحد',
        2 => 'اثنان',
        3 => 'ثلاثة',
        4 => 'أربعة',
        5 => 'خمسة',
        6 => 'ستة',
        7 => 'سبعة',
        8 => 'ثمانية',
        9 => 'تسعة',
        10 => 'عشرة',
        11 => 'أحد عشر',
        12 => 'اثنا عشر',
        13 => 'ثلاثة عشر',
        14 => 'أربعة عشر',
        15 => 'خمسة عشر',
        16 => 'ستة عشر',
        17 => 'سبعة عشر',
        18 => 'ثمانية عشر',
        19 => 'تسعة عشر',
        20 => 'عشرون',
        30 => 'ثلاثون',
        40 => 'أربعون',
        50 => 'خمسون',
        60 => 'ستون',
        70 => 'سبعون',
        80 => 'ثمانون',
        90 => 'تسعون'
    ];

    $digitsEn = ['', 'hundred', 'thousand', 'lakh', 'crore'];
    $digitsAr = ['', 'مائة', 'ألف', 'لكح', 'كرور'];

    $str = [];
    $i = 0;
    $tempNo = $no;

    while ($tempNo > 0) {
        $divider = ($i == 2) ? 10 : 100;
        $numberPart = $tempNo % $divider;
        $tempNo = (int)($tempNo / $divider);
        $i += ($divider == 10) ? 1 : 2;

        if ($numberPart) {
            if ($locale == Locale::Arabic->value) {
                $word = ($numberPart < 21)
                    ? $wordsAr[$numberPart]
                    : $wordsAr[floor($numberPart / 10) * 10] . ' ' . $wordsAr[$numberPart % 10];
                $str[] = trim($word . ' ' . $digitsAr[count($str)]);
            } else {
                $word = ($numberPart < 21)
                    ? $wordsEn[$numberPart]
                    : $wordsEn[floor($numberPart / 10) * 10] . ' ' . $wordsEn[$numberPart % 10];
                $str[] = trim($word . ' ' . $digitsEn[count($str)]);
            }
        } else {
            $str[] = null;
        }
    }

    $str = array_reverse($str);
    $result = trim(implode(' ', $str));

    if ($point > 0) {
        if ($locale == Locale::Arabic->value) {
            $points = ($point < 21)
                ? $wordsAr[$point]
                : $wordsAr[floor($point / 10) * 10] . ' ' . $wordsAr[$point % 10];
            return "$result $mainUnit و $points $subUnit فقط";
        } else {
            $points = ($point < 21)
                ? $wordsEn[$point]
                : $wordsEn[floor($point / 10) * 10] . ' ' . $wordsEn[$point % 10];
            return ucfirst("$result $mainUnit and $points $subUnit only");
        }
    }

    return ($locale == Locale::Arabic->value)
        ? "$result $mainUnit فقط"
        : ucfirst("$result $mainUnit only");
}


function getCityNameByAirportCode($airportCode)
{
    if (!$airportCode) {
        return null;
    }

    $airport = Airport::where('iata_code', $airportCode)->first();

    if (!$airport || !$airport->city_code) {
        return null;
    }

    $city = City::where('iso_code', $airport->city_code)->first();

    if (!$city) {
        return null;
    }

    return CityI18n::where('city_id', $city->id)
        ->where('language_code', Locale::English->value)
        ->value('city_name');
}
function getCountryNameByAirportCode($airportCode)
{
    if (!$airportCode) {
        return null;
    }

    $airport = Airport::where('iata_code', $airportCode)->first();

    if (!$airport || !$airport->country_code) {
        return null;
    }

    $country = Country::where('iso_code', $airport->country_code)->first();

    if (!$country) {
        return null;
    }

    return CountryI18ns::where('country_id', $country->id)
        ->where('language_code', Locale::English->value)
        ->value('country_name');
}


function getTranslatedCityName($cityName, $lang)
{
    $cityId = CityI18n::where('city_name', $cityName)->value('city_id');
    if ($cityId) {
        $translatedCityName = CityI18n::where('city_id', $cityId)->where('language_code', $lang)?->value('city_name');
        return $translatedCityName;
    }
}


function fetchTranslateJson($id)
{
    $langCode = Language::where('id', $id)->value('language_code');

    $folder_path = storage_path('app/public/locale/b2c/');
    $path = $folder_path . $langCode . '.json';

    // Check if the folder exists, if not, create it
    if (!file_exists($folder_path)) {
        mkdir($folder_path, 0777, true);
    }

    // Check if the file exists, if not, create it
    if (!file_exists($path)) {
        file_put_contents($path, '{}');

        chmod($path, 0777);
    }
    $englishJsonContent = Storage::disk('public')->get('/locale/b2c/en.json');
    $arabicJsonContent = Storage::disk('public')->get('/locale/b2c/ar.json');
    return [
        'langCode' => $langCode,
        'englishJsonContent' => $englishJsonContent,
        'arabicJsonContent' => $arabicJsonContent,

    ];
}

// For invoice,ticket and Voucher pdf
function getCurrencyImage($currency = 'SAR')
{
    $invoiceSettings = InvoiceSetting::select('sar_icon', 'usd_icon')->first();
    $sarIcon = $usdIcon = null;
    if ($invoiceSettings) {
        $sarIcon = asset('storage/' . $invoiceSettings->sar_icon);
        $usdIcon = asset('storage/' . $invoiceSettings->usd_icon);
    }
    switch (strtoupper($currency)) {
        case 'USD':
            $imagePath = $usdIcon ?? asset('assets/images/usd.png');
            break;
        case 'SAR':
        default:
            $imagePath = $sarIcon ?? asset('assets/images/sar.png');
            break;
    }

    return '<img src="' . $imagePath . '" alt="' . e($currency) . '" style="width: 15px; margin-right: 5px;">';
}

function getCabinClass($cabin = 'ECONOMY', $locale)
{
    if ($locale == Locale::English->value) {
        return $cabin;
    }
    $cabinClass = 'اقتصاد';
    if ($cabin == 'ECONOMY') {
        $cabinClass = 'اقتصاد';
    } else if ($cabin == 'PREMIUM_ECONOMY') {
        $cabinClass = 'الاقتصاد المتميز';
    } else if ($cabin == 'BUSINESS') {
        $cabinClass = 'عمل';
    } else if ($cabin == 'FIRST') {
        $cabinClass = 'أولاً';
    } else {
        $cabinClass = 'اقتصاد';
    }
    return  $cabinClass;
}


function getServiceFee($serviceType = ServiceType::Flight->value)
{
    $generalVATPercentage = Setting::where('config_key', 'general|site|defaultVatPercentage')->get('value')[0]['value'];
    if (!$generalVATPercentage) {
        $generalVATPercentage = 0;
    }
    if ($serviceType == ServiceType::Flight->value) {
        $generalServiceFee = Setting::where('config_key', 'general|site|flightServiceFee')->get('value')[0]['value'];
    } else {
        $generalServiceFee = Setting::where('config_key', 'general|site|hotelServiceFee')->get('value')[0]['value'];
    }
    if (!$generalServiceFee) {
        $generalServiceFee = 0;
    }
    $vat = (float) $generalServiceFee * ((float) $generalVATPercentage / 100);

    $serviceFee = (float) $generalServiceFee + (float) $vat;
    
    return [
        'vat' => $vat,
        'serviceFee' => $serviceFee
    ];
}
